/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.search.SearchApplicationTemplate;

public class SearchApplication
implements Writeable,
ToXContentObject {
    public static final String NO_TEMPLATE_STORED_WARNING = "Using default search application template which is subject to change. We recommend storing a template to avoid breaking changes.";
    private final String name;
    private final String[] indices;
    private final long updatedAtMillis;
    private final String analyticsCollectionName;
    private final SearchApplicationTemplate searchApplicationTemplate;
    private static final ConstructingObjectParser<SearchApplication, String> PARSER = new ConstructingObjectParser("search_application", false, (params, resourceName) -> {
        String name = (String)params[0];
        if (name != null && !name.equals(resourceName)) {
            throw new IllegalArgumentException("Search Application name [" + name + "] does not match the resource name: [" + resourceName + "]");
        }
        String[] indices = params[1] != null ? (String[])((List)params[1]).toArray(String[]::new) : new String[]{};
        String analyticsCollectionName = (String)params[2];
        Long maybeUpdatedAtMillis = (Long)params[3];
        long updatedAtMillis = maybeUpdatedAtMillis != null ? maybeUpdatedAtMillis : System.currentTimeMillis();
        SearchApplicationTemplate template = (SearchApplicationTemplate)params[4];
        return new SearchApplication((String)resourceName, indices, analyticsCollectionName, updatedAtMillis, template);
    });
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField ANALYTICS_COLLECTION_NAME_FIELD = new ParseField("analytics_collection_name", new String[0]);
    public static final ParseField TEMPLATE_FIELD = new ParseField("template", new String[0]);
    public static final ParseField TEMPLATE_SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField UPDATED_AT_MILLIS_FIELD = new ParseField("updated_at_millis", new String[0]);
    public static final ParseField BINARY_CONTENT_FIELD = new ParseField("binary_content", new String[0]);

    public SearchApplication(String name, String[] indices, @Nullable String analyticsCollectionName, long updatedAtMillis, @Nullable SearchApplicationTemplate searchApplicationTemplate) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Search Application name cannot be null or blank");
        }
        this.name = name;
        Objects.requireNonNull(indices, "Search Application indices cannot be null");
        this.indices = (String[])indices.clone();
        Arrays.sort(this.indices);
        this.analyticsCollectionName = analyticsCollectionName;
        this.updatedAtMillis = updatedAtMillis;
        this.searchApplicationTemplate = searchApplicationTemplate;
    }

    public SearchApplication(StreamInput in) throws IOException {
        this.name = in.readString();
        this.indices = in.readStringArray();
        this.analyticsCollectionName = in.readOptionalString();
        this.updatedAtMillis = in.readLong();
        this.searchApplicationTemplate = (SearchApplicationTemplate)in.readOptionalWriteable(SearchApplicationTemplate::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringArray(this.indices);
        out.writeOptionalString(this.analyticsCollectionName);
        out.writeLong(this.updatedAtMillis);
        out.writeOptionalWriteable((Writeable)this.searchApplicationTemplate);
    }

    public static SearchApplication fromXContentBytes(String resourceName, BytesReference source, XContentType xContentType) {
        SearchApplication searchApplication;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                searchApplication = SearchApplication.fromXContent(resourceName, parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return searchApplication;
    }

    public static SearchApplication fromXContent(String resourceName, XContentParser parser) throws IOException {
        return (SearchApplication)PARSER.parse(parser, (Object)resourceName);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        if (this.analyticsCollectionName != null) {
            builder.field(ANALYTICS_COLLECTION_NAME_FIELD.getPreferredName(), this.analyticsCollectionName);
        }
        builder.field(UPDATED_AT_MILLIS_FIELD.getPreferredName(), this.updatedAtMillis);
        builder.field(TEMPLATE_FIELD.getPreferredName(), (ToXContent)this.searchApplicationTemplate);
        builder.endObject();
        return builder;
    }

    public String name() {
        return this.name;
    }

    public String[] indices() {
        return this.indices;
    }

    @Nullable
    public String analyticsCollectionName() {
        return this.analyticsCollectionName;
    }

    public long updatedAtMillis() {
        return this.updatedAtMillis;
    }

    public boolean hasStoredTemplate() {
        return this.searchApplicationTemplate != null;
    }

    public SearchApplicationTemplate searchApplicationTemplateOrDefault() {
        return this.hasStoredTemplate() ? this.searchApplicationTemplate : SearchApplicationTemplate.DEFAULT_TEMPLATE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchApplication app = (SearchApplication)o;
        return this.name.equals(app.name) && Objects.equals(this.analyticsCollectionName, app.analyticsCollectionName) && this.updatedAtMillis == app.updatedAtMillis() && Objects.equals(this.searchApplicationTemplate, app.searchApplicationTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.analyticsCollectionName, this.updatedAtMillis, this.searchApplicationTemplate);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    SearchApplication merge(BytesReference update, XContentType xContentType, BigArrays bigArrays) throws IOException {
        boolean noop;
        Tuple sourceAndContent;
        try (ReleasableBytesStreamOutput sourceBuffer = new ReleasableBytesStreamOutput(0, bigArrays.withCircuitBreaking());){
            try (XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)sourceBuffer);){
                this.toXContent(builder, EMPTY_PARAMS);
            }
            sourceAndContent = XContentHelper.convertToMap((BytesReference)sourceBuffer.bytes(), (boolean)true, (XContentType)XContentType.JSON);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Tuple updateAndContent = XContentHelper.convertToMap((BytesReference)update, (boolean)true, (XContentType)xContentType);
        HashMap newSourceAsMap = new HashMap((Map)sourceAndContent.v2());
        boolean bl = noop = !XContentHelper.update(newSourceAsMap, (Map)((Map)updateAndContent.v2()), (boolean)true);
        if (noop) {
            return this;
        }
        try (ReleasableBytesStreamOutput newSourceBuffer = new ReleasableBytesStreamOutput(0, bigArrays.withCircuitBreaking());){
            try (XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)newSourceBuffer);){
                builder.value(newSourceAsMap);
            }
            SearchApplication searchApplication = SearchApplication.fromXContentBytes(this.name, newSourceBuffer.bytes(), XContentType.JSON);
            return searchApplication;
        }
    }

    static {
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), NAME_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), INDICES_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ANALYTICS_COLLECTION_NAME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), UPDATED_AT_MILLIS_FIELD);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchApplicationTemplate.parse(p), null, TEMPLATE_FIELD);
    }
}

