/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.QueryRuleset;
import org.elasticsearch.xpack.application.rules.action.PutQueryRulesetAction;

public class TransportPutQueryRulesetAction
extends HandledTransportAction<PutQueryRulesetAction.Request, PutQueryRulesetAction.Response> {
    protected final QueryRulesIndexService systemIndexService;

    @Inject
    public TransportPutQueryRulesetAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/query_rules/put", transportService, actionFilters, PutQueryRulesetAction.Request::new);
        this.systemIndexService = new QueryRulesIndexService(client, clusterService.getClusterSettings());
    }

    protected void doExecute(Task task, PutQueryRulesetAction.Request request, ActionListener<PutQueryRulesetAction.Response> listener) {
        QueryRuleset queryRuleset = request.queryRuleset();
        this.systemIndexService.putQueryRuleset(queryRuleset, (ActionListener<IndexResponse>)listener.map(r -> new PutQueryRulesetAction.Response(r.getResult())));
    }
}

