/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.action.ListQueryRulesetsAction;
import org.elasticsearch.xpack.core.action.util.PageParams;

public class TransportListQueryRulesetsAction
extends HandledTransportAction<ListQueryRulesetsAction.Request, ListQueryRulesetsAction.Response> {
    protected final QueryRulesIndexService systemIndexService;

    @Inject
    public TransportListQueryRulesetsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/query_rules/list", transportService, actionFilters, ListQueryRulesetsAction.Request::new);
        this.systemIndexService = new QueryRulesIndexService(client, clusterService.getClusterSettings());
    }

    protected void doExecute(Task task, ListQueryRulesetsAction.Request request, ActionListener<ListQueryRulesetsAction.Response> listener) {
        PageParams pageParams = request.pageParams();
        this.systemIndexService.listQueryRulesets(pageParams.getFrom(), pageParams.getSize(), (ActionListener<QueryRulesIndexService.QueryRulesetResult>)listener.map(r -> new ListQueryRulesetsAction.Response(r.rulesets(), r.totalResults())));
    }
}

