/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.util.List;
import java.util.Locale;
import org.apache.lucene.search.spell.LevenshteinDistance;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum QueryRuleCriteriaType {
    ALWAYS{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            return true;
        }
    }
    ,
    EXACT{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            if (input instanceof String && criteriaValue instanceof String) {
                return input.equals(criteriaValue);
            }
            return QueryRuleCriteriaType.parseDouble(input) == QueryRuleCriteriaType.parseDouble(criteriaValue);
        }
    }
    ,
    FUZZY{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            LevenshteinDistance ld = new LevenshteinDistance();
            if (input instanceof String && criteriaValue instanceof String) {
                return ld.getDistance((String)input, (String)criteriaValue) > 0.5f;
            }
            return false;
        }
    }
    ,
    PREFIX{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            return ((String)input).startsWith((String)criteriaValue);
        }
    }
    ,
    SUFFIX{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            return ((String)input).endsWith((String)criteriaValue);
        }
    }
    ,
    CONTAINS{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            return ((String)input).contains((String)criteriaValue);
        }
    }
    ,
    LT{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            return QueryRuleCriteriaType.parseDouble(input) < QueryRuleCriteriaType.parseDouble(criteriaValue);
        }
    }
    ,
    LTE{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            return QueryRuleCriteriaType.parseDouble(input) <= QueryRuleCriteriaType.parseDouble(criteriaValue);
        }
    }
    ,
    GT{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            return QueryRuleCriteriaType.parseDouble(input) > QueryRuleCriteriaType.parseDouble(criteriaValue);
        }
    }
    ,
    GTE{

        @Override
        public boolean isMatch(Object input, Object criteriaValue) {
            this.validateInput(input);
            return QueryRuleCriteriaType.parseDouble(input) >= QueryRuleCriteriaType.parseDouble(criteriaValue);
        }
    };


    public void validateInput(Object input) {
        boolean isValid = this.isValidForInput(input);
        if (!isValid) {
            throw new IllegalArgumentException("Input [" + input + "] is not valid for CriteriaType [" + this + "]");
        }
    }

    public abstract boolean isMatch(Object var1, Object var2);

    public static QueryRuleCriteriaType type(String criteriaType) {
        for (QueryRuleCriteriaType type : QueryRuleCriteriaType.values()) {
            if (!type.name().equalsIgnoreCase(criteriaType)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown QueryRuleCriteriaType: " + criteriaType);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private boolean isValidForInput(Object input) {
        if (this == EXACT) {
            return input instanceof String || input instanceof Number;
        }
        if (List.of(FUZZY, PREFIX, SUFFIX, CONTAINS).contains((Object)this)) {
            return input instanceof String;
        }
        if (List.of(LT, LTE, GT, GTE).contains((Object)this)) {
            try {
                if (!(input instanceof Number)) {
                    QueryRuleCriteriaType.parseDouble(input.toString());
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private static double parseDouble(Object input) {
        return input instanceof Number ? ((Number)input).doubleValue() : Double.parseDouble(input.toString());
    }
}

