/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollectionService;
import org.elasticsearch.xpack.application.analytics.action.PutAnalyticsCollectionAction;

public class TransportPutAnalyticsCollectionAction
extends TransportMasterNodeAction<PutAnalyticsCollectionAction.Request, PutAnalyticsCollectionAction.Response> {
    private final AnalyticsCollectionService analyticsCollectionService;

    @Inject
    public TransportPutAnalyticsCollectionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AnalyticsCollectionService analyticsCollectionService) {
        super("cluster:admin/xpack/application/analytics/put", transportService, clusterService, threadPool, actionFilters, PutAnalyticsCollectionAction.Request::new, indexNameExpressionResolver, PutAnalyticsCollectionAction.Response::new, "same");
        this.analyticsCollectionService = analyticsCollectionService;
    }

    protected ClusterBlockException checkBlock(PutAnalyticsCollectionAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, PutAnalyticsCollectionAction.Request request, ClusterState state, ActionListener<PutAnalyticsCollectionAction.Response> listener) {
        this.analyticsCollectionService.putAnalyticsCollection(state, request, listener);
    }
}

