/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application;

import java.util.Collections;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.analytics.action.GetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteriaType;
import org.elasticsearch.xpack.application.rules.QueryRulesetListItem;
import org.elasticsearch.xpack.application.rules.action.ListQueryRulesetsAction;
import org.elasticsearch.xpack.application.search.action.ListSearchApplicationAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.application.EnterpriseSearchFeatureSetUsage;

public class EnterpriseSearchUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private static final Logger logger = LogManager.getLogger(EnterpriseSearchUsageTransportAction.class);
    private final XPackLicenseState licenseState;
    private final OriginSettingClient clientWithOrigin;
    private final IndicesAdminClient indicesAdminClient;
    private final boolean enabled;

    @Inject
    public EnterpriseSearchUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Settings settings, XPackLicenseState licenseState, Client client) {
        super(XPackUsageFeatureAction.ENTERPRISE_SEARCH.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.clientWithOrigin = new OriginSettingClient(client, "enterprise_search");
        this.indicesAdminClient = this.clientWithOrigin.admin().indices();
        this.enabled = (Boolean)XPackSettings.ENTERPRISE_SEARCH_ENABLED.get(settings);
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        if (!this.enabled) {
            EnterpriseSearchFeatureSetUsage usage = new EnterpriseSearchFeatureSetUsage(LicenseUtils.LICENSED_ENT_SEARCH_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
            listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)usage));
            return;
        }
        HashMap searchApplicationsUsage = new HashMap();
        HashMap analyticsCollectionsUsage = new HashMap();
        HashMap queryRulesUsage = new HashMap();
        ListSearchApplicationAction.Request searchApplicationsCountRequest = new ListSearchApplicationAction.Request("*", new PageParams(0, 0));
        ActionListener searchApplicationsCountListener = ActionListener.wrap(response -> {
            this.addSearchApplicationsUsage((ListSearchApplicationAction.Response)((Object)response), searchApplicationsUsage);
            listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)new EnterpriseSearchFeatureSetUsage(LicenseUtils.LICENSED_ENT_SEARCH_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, searchApplicationsUsage, analyticsCollectionsUsage, queryRulesUsage)));
        }, e -> listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)new EnterpriseSearchFeatureSetUsage(LicenseUtils.LICENSED_ENT_SEARCH_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, Collections.emptyMap(), analyticsCollectionsUsage, queryRulesUsage))));
        final ActionListener listQueryRulesetsListener = ActionListener.wrap(response -> {
            this.addQueryRulesetUsage((ListQueryRulesetsAction.Response)((Object)response), queryRulesUsage);
            this.clientWithOrigin.execute((ActionType)ListSearchApplicationAction.INSTANCE, (ActionRequest)searchApplicationsCountRequest, searchApplicationsCountListener);
        }, e -> this.clientWithOrigin.execute((ActionType)ListSearchApplicationAction.INSTANCE, (ActionRequest)searchApplicationsCountRequest, searchApplicationsCountListener));
        IndicesStatsRequest indicesStatsRequest = (IndicesStatsRequest)this.indicesAdminClient.prepareStats(new String[]{".query-rules"}).setDocs(true).request();
        GetAnalyticsCollectionAction.Request analyticsCollectionsCountRequest = new GetAnalyticsCollectionAction.Request(new String[]{"*"});
        ActionListener analyticsCollectionsCountListener = ActionListener.wrap(response -> {
            this.addAnalyticsCollectionsUsage((GetAnalyticsCollectionAction.Response)((Object)response), analyticsCollectionsUsage);
            this.indicesAdminClient.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)indicesStatsRequest, (ActionListener)new ActionListener<IndicesStatsResponse>(){

                public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                    Map indicesStats = indicesStatsResponse.getIndices();
                    int queryRulesetCount = indicesStats.values().stream().mapToInt(indexShardStats -> (int)indexShardStats.getPrimaries().getDocs().getCount()).sum();
                    ListQueryRulesetsAction.Request queryRulesetsCountRequest = new ListQueryRulesetsAction.Request(new PageParams(0, queryRulesetCount));
                    EnterpriseSearchUsageTransportAction.this.clientWithOrigin.execute((ActionType)ListQueryRulesetsAction.INSTANCE, (ActionRequest)queryRulesetsCountRequest, listQueryRulesetsListener);
                }

                public void onFailure(Exception e) {
                    ListQueryRulesetsAction.Request queryRulesetsCountRequest = new ListQueryRulesetsAction.Request(new PageParams(0, 0));
                    EnterpriseSearchUsageTransportAction.this.clientWithOrigin.execute((ActionType)ListQueryRulesetsAction.INSTANCE, (ActionRequest)queryRulesetsCountRequest, listQueryRulesetsListener);
                }
            });
        }, e -> {
            ListQueryRulesetsAction.Request queryRulesetsCountRequest = new ListQueryRulesetsAction.Request(new PageParams(0, 0));
            this.clientWithOrigin.execute((ActionType)ListQueryRulesetsAction.INSTANCE, (ActionRequest)queryRulesetsCountRequest, listQueryRulesetsListener);
        });
        this.clientWithOrigin.execute((ActionType)GetAnalyticsCollectionAction.INSTANCE, (ActionRequest)analyticsCollectionsCountRequest, analyticsCollectionsCountListener);
    }

    private void addSearchApplicationsUsage(ListSearchApplicationAction.Response response, Map<String, Object> searchApplicationsUsage) {
        long count = response.queryPage().count();
        searchApplicationsUsage.put("count", count);
    }

    private void addAnalyticsCollectionsUsage(GetAnalyticsCollectionAction.Response response, Map<String, Object> analyticsCollectionsUsage) {
        long count = response.getAnalyticsCollections().size();
        analyticsCollectionsUsage.put("count", count);
    }

    private void addQueryRulesetUsage(ListQueryRulesetsAction.Response response, Map<String, Object> queryRulesUsage) {
        List results = response.queryPage().results();
        IntSummaryStatistics ruleStats = results.stream().mapToInt(QueryRulesetListItem::ruleTotalCount).summaryStatistics();
        HashMap<QueryRuleCriteriaType, Integer> criteriaTypeCountMap = new HashMap<QueryRuleCriteriaType, Integer>();
        results.stream().flatMap(result -> result.criteriaTypeToCountMap().entrySet().stream()).forEach(entry -> criteriaTypeCountMap.merge((QueryRuleCriteriaType)((Object)((Object)entry.getKey())), (Integer)entry.getValue(), Integer::sum));
        HashMap rulesTypeCountMap = new HashMap();
        criteriaTypeCountMap.forEach((criteriaType, count) -> rulesTypeCountMap.put(criteriaType.name().toLowerCase(Locale.ROOT), count));
        queryRulesUsage.put("total_count", response.queryPage().count());
        queryRulesUsage.put("total_rule_count", ruleStats.getSum());
        queryRulesUsage.put("min_rule_count", results.isEmpty() ? 0 : ruleStats.getMin());
        queryRulesUsage.put("max_rule_count", results.isEmpty() ? 0 : ruleStats.getMax());
        if (!rulesTypeCountMap.isEmpty()) {
            queryRulesUsage.put("rule_criteria_total_counts", rulesTypeCountMap);
        }
    }
}

