/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.profile;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.security.action.profile.SuggestProfilesAction;
import org.elasticsearch.xpack.core.security.action.profile.SuggestProfilesRequest;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestSuggestProfilesAction
extends SecurityBaseRestHandler {
    static final ConstructingObjectParser<Payload, Void> PARSER = new ConstructingObjectParser("suggest_profile_request_payload", a -> new Payload((String)a[0], (Integer)a[1], (PayloadHint)a[2], (String)a[3]));
    static final ConstructingObjectParser<PayloadHint, Void> HINT_PARSER = new ConstructingObjectParser("suggest_profile_request_payload_hint", a -> new PayloadHint((List)a[0], (Map)a[1]));

    public RestSuggestProfilesAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/profile/_suggest"), new RestHandler.Route(RestRequest.Method.POST, "/_security/profile/_suggest"));
    }

    public String getName() {
        return "xpack_security_suggest_profile";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        Payload payload = request.hasContentOrSourceParam() ? (Payload)PARSER.parse(request.contentOrSourceParamParser(), null) : new Payload(null, null, null, null);
        String data = request.param("data", null);
        if (data != null && payload.data() != null) {
            throw new IllegalArgumentException("The [data] parameter must be specified in either request body or as query parameter, but not both");
        }
        Set dataKeys = Strings.tokenizeByCommaToSet((String)(data != null ? data : payload.data()));
        SuggestProfilesRequest suggestProfilesRequest = new SuggestProfilesRequest(dataKeys, payload.name(), payload.size().intValue(), payload.hint() == null ? null : new SuggestProfilesRequest.Hint(payload.hint().uids(), payload.hint().labels()));
        HttpChannel httpChannel = request.getHttpChannel();
        return channel -> new RestCancellableNodeClient(client, httpChannel).execute((ActionType)SuggestProfilesAction.INSTANCE, (ActionRequest)suggestProfilesRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @Override
    protected Exception checkFeatureAvailable(RestRequest request) {
        Exception failedFeature = super.checkFeatureAvailable(request);
        if (failedFeature != null) {
            return failedFeature;
        }
        if (Security.USER_PROFILE_COLLABORATION_FEATURE.check(this.licenseState)) {
            return null;
        }
        return LicenseUtils.newComplianceException((String)Security.USER_PROFILE_COLLABORATION_FEATURE.getName());
    }

    static {
        HINT_PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("uids", new String[0]));
        HINT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("labels", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("name", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("size", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), HINT_PARSER, new ParseField("hint", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("data", new String[0]));
    }

    record Payload(String name, Integer size, PayloadHint hint, String data) {
        private final String name;
        private final Integer size;

        public String name() {
            return this.name != null ? this.name : "";
        }

        public Integer size() {
            return this.size != null ? this.size : 10;
        }
    }

    record PayloadHint(List<String> uids, Map<String, Object> labels) {
    }
}

