/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

@ServerlessScope(value=Scope.PUBLIC)
public final class RestUpdateApiKeyAction
extends ApiKeyBaseRestHandler {
    static final ConstructingObjectParser<Payload, Void> PARSER = new ConstructingObjectParser("update_api_key_request_payload", a -> new Payload((List)a[0], (Map)a[1]));

    public RestUpdateApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_security/api_key/{ids}"));
    }

    public String getName() {
        return "xpack_security_update_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String apiKeyId = request.param("ids");
        Payload payload = !request.hasContent() ? new Payload(null, null) : (Payload)PARSER.parse(request.contentParser(), null);
        return channel -> client.execute((ActionType)UpdateApiKeyAction.INSTANCE, (ActionRequest)new UpdateApiKeyRequest(apiKeyId, payload.roleDescriptors, payload.metadata), (ActionListener)new RestToXContentListener(channel));
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
            p.nextToken();
            return RoleDescriptor.parse((String)n, (XContentParser)p, (boolean)false);
        }, new ParseField("role_descriptors", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
    }

    record Payload(List<RoleDescriptor> roleDescriptors, Map<String, Object> metadata) {
    }
}

