/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;

public class TransportHasPrivilegesAction
extends HandledTransportAction<HasPrivilegesRequest, HasPrivilegesResponse> {
    private final AuthorizationService authorizationService;
    private final NativePrivilegeStore privilegeStore;
    private final SecurityContext securityContext;

    @Inject
    public TransportHasPrivilegesAction(TransportService transportService, ActionFilters actionFilters, AuthorizationService authorizationService, NativePrivilegeStore privilegeStore, SecurityContext context) {
        super("cluster:admin/xpack/security/user/has_privileges", transportService, actionFilters, HasPrivilegesRequest::new);
        this.authorizationService = authorizationService;
        this.privilegeStore = privilegeStore;
        this.securityContext = context;
    }

    protected void doExecute(Task task, HasPrivilegesRequest request, ActionListener<HasPrivilegesResponse> listener) {
        String username = request.username();
        Authentication authentication = this.securityContext.getAuthentication();
        if (!TransportHasPrivilegesAction.isSameUser(authentication, username)) {
            listener.onFailure((Exception)new IllegalArgumentException("users may only check the privileges of their own account"));
            return;
        }
        this.resolveApplicationPrivileges(request, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(applicationPrivilegeDescriptors -> this.authorizationService.checkPrivileges(authentication.getEffectiveSubject(), request.getPrivilegesToCheck(), (Collection<ApplicationPrivilegeDescriptor>)applicationPrivilegeDescriptors, (ActionListener<AuthorizationEngine.PrivilegesCheckResult>)listener.map(privilegesCheckResult -> {
            AuthorizationEngine.PrivilegesCheckResult.Details checkResultDetails = privilegesCheckResult.getDetails();
            assert (checkResultDetails != null) : "runDetailedCheck is 'true' but the result has no details";
            return new HasPrivilegesResponse(request.username(), privilegesCheckResult.allChecksSuccess(), checkResultDetails != null ? checkResultDetails.cluster() : Map.of(), checkResultDetails != null ? checkResultDetails.index().values() : List.of(), checkResultDetails != null ? checkResultDetails.application() : Map.of());
        })), arg_0 -> listener.onFailure(arg_0)));
    }

    private void resolveApplicationPrivileges(HasPrivilegesRequest request, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        Set<String> applications = TransportHasPrivilegesAction.getApplicationNames(request);
        this.privilegeStore.getPrivileges(applications, null, listener);
    }

    public static Set<String> getApplicationNames(HasPrivilegesRequest request) {
        return Arrays.stream(request.applicationPrivileges()).map(RoleDescriptor.ApplicationResourcePrivileges::getApplication).collect(Collectors.toSet());
    }

    private static boolean isSameUser(Authentication authentication, String username) {
        Subject subjectToCheck = authentication.isCrossClusterAccess() ? Authentication.getAuthenticationFromCrossClusterAccessMetadata((Authentication)authentication).getEffectiveSubject() : authentication.getEffectiveSubject();
        return subjectToCheck.getUser().principal().equals(username);
    }
}

