/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.profile;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.profile.SetProfileEnabledRequest;
import org.elasticsearch.xpack.security.profile.ProfileService;

public class TransportSetProfileEnabledAction
extends HandledTransportAction<SetProfileEnabledRequest, AcknowledgedResponse> {
    private final ProfileService profileService;

    @Inject
    public TransportSetProfileEnabledAction(TransportService transportService, ActionFilters actionFilters, ProfileService profileService) {
        super("cluster:admin/xpack/security/profile/set_enabled", transportService, actionFilters, SetProfileEnabledRequest::new);
        this.profileService = profileService;
    }

    protected void doExecute(Task task, SetProfileEnabledRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.profileService.setEnabled(request.getUid(), request.isEnabled(), request.getRefreshPolicy(), listener);
    }
}

