/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.profile;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.common.ResultsAndErrors;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.ProfileHasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.ProfileHasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;
import org.elasticsearch.xpack.security.profile.ProfileService;

public class TransportProfileHasPrivilegesAction
extends HandledTransportAction<ProfileHasPrivilegesRequest, ProfileHasPrivilegesResponse> {
    private static final Logger logger = LogManager.getLogger(TransportProfileHasPrivilegesAction.class);
    private final AuthorizationService authorizationService;
    private final NativePrivilegeStore privilegeStore;
    private final ProfileService profileService;
    private final SecurityContext securityContext;
    private final ThreadPool threadPool;

    @Inject
    public TransportProfileHasPrivilegesAction(TransportService transportService, ActionFilters actionFilters, AuthorizationService authorizationService, NativePrivilegeStore privilegeStore, ProfileService profileService, SecurityContext securityContext, ThreadPool threadPool) {
        super("cluster:admin/xpack/security/profile/has_privileges", transportService, actionFilters, ProfileHasPrivilegesRequest::new);
        this.authorizationService = authorizationService;
        this.privilegeStore = privilegeStore;
        this.profileService = profileService;
        this.securityContext = securityContext;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, ProfileHasPrivilegesRequest request, ActionListener<ProfileHasPrivilegesResponse> listener) {
        assert (task instanceof CancellableTask) : "task must be cancellable";
        this.profileService.getProfileSubjects(request.profileUids(), (ActionListener<ResultsAndErrors<Map.Entry<String, Subject>>>)ActionListener.wrap(profileSubjectsAndFailures -> {
            if (profileSubjectsAndFailures.results().isEmpty()) {
                listener.onResponse((Object)new ProfileHasPrivilegesResponse(Set.of(), profileSubjectsAndFailures.errors()));
                return;
            }
            Set hasPrivilegeProfiles = Collections.synchronizedSet(new HashSet());
            ConcurrentHashMap errorProfiles = new ConcurrentHashMap(profileSubjectsAndFailures.errors());
            AtomicInteger counter = new AtomicInteger(profileSubjectsAndFailures.results().size());
            assert (counter.get() > 0);
            this.resolveApplicationPrivileges(request, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(applicationPrivilegeDescriptors -> this.threadPool.generic().execute(() -> {
                for (Map.Entry profileUidToSubject : profileSubjectsAndFailures.results()) {
                    if (((CancellableTask)task).isCancelled()) {
                        listener.onFailure((Exception)new TaskCancelledException("has privilege task cancelled"));
                        return;
                    }
                    String profileUid = (String)profileUidToSubject.getKey();
                    Subject subject = (Subject)profileUidToSubject.getValue();
                    this.authorizationService.checkPrivileges(subject, request.privilegesToCheck(), (Collection<ApplicationPrivilegeDescriptor>)applicationPrivilegeDescriptors, (ActionListener<AuthorizationEngine.PrivilegesCheckResult>)ActionListener.runAfter((ActionListener)ActionListener.wrap(privilegesCheckResult -> {
                        assert (privilegesCheckResult.getDetails() == null);
                        if (privilegesCheckResult.allChecksSuccess()) {
                            hasPrivilegeProfiles.add(profileUid);
                        }
                    }, checkPrivilegesException -> {
                        logger.debug(() -> "Failed to check privileges for profile [" + profileUid + "]", (Throwable)checkPrivilegesException);
                        errorProfiles.put(profileUid, checkPrivilegesException);
                    }), () -> {
                        if (counter.decrementAndGet() == 0) {
                            listener.onResponse((Object)new ProfileHasPrivilegesResponse(hasPrivilegeProfiles, errorProfiles));
                        }
                    }));
                }
            }), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void resolveApplicationPrivileges(ProfileHasPrivilegesRequest request, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        Set<String> applications = Arrays.stream(request.privilegesToCheck().application()).map(RoleDescriptor.ApplicationResourcePrivileges::getApplication).collect(Collectors.toSet());
        this.privilegeStore.getPrivileges(applications, null, listener);
    }
}

