/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.InvalidateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportInvalidateApiKeyAction
extends HandledTransportAction<InvalidateApiKeyRequest, InvalidateApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;

    @Inject
    public TransportInvalidateApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context) {
        super("cluster:admin/xpack/security/api_key/invalidate", transportService, actionFilters, InvalidateApiKeyRequest::new);
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
    }

    protected void doExecute(Task task, InvalidateApiKeyRequest request, ActionListener<InvalidateApiKeyResponse> listener) {
        String[] stringArray;
        String[] apiKeyIds = request.getIds();
        String apiKeyName = request.getName();
        String username = request.getUserName();
        if (Strings.hasText((String)request.getRealmName())) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = request.getRealmName();
        } else {
            stringArray = null;
        }
        String[] realms = stringArray;
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        }
        if (request.ownedByAuthenticatedUser()) {
            assert (username == null);
            assert (realms == null);
            username = authentication.getEffectiveSubject().getUser().principal();
            realms = ApiKeyService.getOwnersRealmNames(authentication);
        }
        this.apiKeyService.invalidateApiKeys(realms, username, apiKeyName, apiKeyIds, listener);
    }
}

