/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.profiling.StackFrame;
import org.elasticsearch.xpack.profiling.StackTrace;

public class GetStackTracesResponse
extends ActionResponse
implements ChunkedToXContentObject {
    @Nullable
    private final Map<String, StackTrace> stackTraces;
    @Nullable
    private final Map<String, StackFrame> stackFrames;
    @Nullable
    private final Map<String, String> executables;
    @Nullable
    private final Map<String, Integer> stackTraceEvents;
    private final int totalFrames;
    private final double samplingRate;

    public GetStackTracesResponse(StreamInput in) throws IOException {
        this.stackTraces = in.readBoolean() ? in.readMap(i -> new StackTrace(i.readList(StreamInput::readInt), i.readList(StreamInput::readString), i.readList(StreamInput::readString), i.readList(StreamInput::readInt))) : null;
        this.stackFrames = in.readBoolean() ? in.readMap(i -> new StackFrame(i.readList(StreamInput::readString), i.readList(StreamInput::readString), i.readList(StreamInput::readInt), i.readList(StreamInput::readInt))) : null;
        this.executables = in.readBoolean() ? in.readMap(StreamInput::readString) : null;
        this.stackTraceEvents = in.readBoolean() ? in.readMap(StreamInput::readInt) : null;
        this.totalFrames = in.readInt();
        this.samplingRate = in.readDouble();
    }

    public GetStackTracesResponse(Map<String, StackTrace> stackTraces, Map<String, StackFrame> stackFrames, Map<String, String> executables, Map<String, Integer> stackTraceEvents, int totalFrames, double samplingRate) {
        this.stackTraces = stackTraces;
        this.stackFrames = stackFrames;
        this.executables = executables;
        this.stackTraceEvents = stackTraceEvents;
        this.totalFrames = totalFrames;
        this.samplingRate = samplingRate;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.stackTraces != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackTraces, StreamOutput::writeString, (o, v) -> {
                o.writeCollection(v.addressOrLines, StreamOutput::writeInt);
                o.writeCollection(v.fileIds, StreamOutput::writeString);
                o.writeCollection(v.frameIds, StreamOutput::writeString);
                o.writeCollection(v.typeIds, StreamOutput::writeInt);
            });
        } else {
            out.writeBoolean(false);
        }
        if (this.stackFrames != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackFrames, StreamOutput::writeString, (o, v) -> {
                o.writeCollection(v.fileName, StreamOutput::writeString);
                o.writeCollection(v.functionName, StreamOutput::writeString);
                o.writeCollection(v.functionOffset, StreamOutput::writeInt);
                o.writeCollection(v.lineNumber, StreamOutput::writeInt);
            });
        } else {
            out.writeBoolean(false);
        }
        if (this.executables != null) {
            out.writeBoolean(true);
            out.writeMap(this.executables, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.stackTraceEvents != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackTraceEvents, StreamOutput::writeString, StreamOutput::writeInt);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.totalFrames);
        out.writeDouble(this.samplingRate);
    }

    public Map<String, StackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public Map<String, StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    public Map<String, String> getExecutables() {
        return this.executables;
    }

    public Map<String, Integer> getStackTraceEvents() {
        return this.stackTraceEvents;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), this.optional("stack_traces", this.stackTraces, ChunkedToXContentHelper::xContentValuesMap), this.optional("stack_frames", this.stackFrames, ChunkedToXContentHelper::xContentValuesMap), this.optional("executables", this.executables, ChunkedToXContentHelper::map), this.optional("stack_trace_events", this.stackTraceEvents, ChunkedToXContentHelper::map), Iterators.single((b, p) -> b.field("total_frames", this.totalFrames)), Iterators.single((b, p) -> b.field("sampling_rate", this.samplingRate)), ChunkedToXContentHelper.endObject()});
    }

    private <T> Iterator<? extends ToXContent> optional(String name, Map<String, T> values, BiFunction<String, Map<String, T>, Iterator<? extends ToXContent>> supplier) {
        return values != null ? supplier.apply(name, values) : Collections.emptyIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetStackTracesResponse response = (GetStackTracesResponse)((Object)o);
        return this.totalFrames == response.totalFrames && this.samplingRate == response.samplingRate && Objects.equals(this.stackTraces, response.stackTraces) && Objects.equals(this.stackFrames, response.stackFrames) && Objects.equals(this.executables, response.executables) && Objects.equals(this.stackTraceEvents, response.stackTraceEvents);
    }

    public int hashCode() {
        return Objects.hash(this.stackTraces, this.stackFrames, this.executables, this.stackTraceEvents, this.totalFrames, this.samplingRate);
    }
}

