/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.profiling.EventsIndex;

public class GetStackTracesRequest
extends ActionRequest
implements IndicesRequest {
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField SAMPLE_SIZE_FIELD = new ParseField("sample_size", new String[0]);
    private QueryBuilder query;
    private Integer sampleSize;

    public GetStackTracesRequest() {
        this(null, null);
    }

    public GetStackTracesRequest(Integer sampleSize, QueryBuilder query) {
        this.sampleSize = sampleSize;
        this.query = query;
    }

    public GetStackTracesRequest(StreamInput in) throws IOException {
        this.query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        this.sampleSize = in.readOptionalInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalNamedWriteable((NamedWriteable)this.query);
        out.writeOptionalInt(this.sampleSize);
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public QueryBuilder getQuery() {
        return this.query;
    }

    public void parseXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        if (token != XContentParser.Token.START_OBJECT && (token = parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [" + XContentParser.Token.START_OBJECT + "] but found [" + token + "]", new Object[]{parser.getTokenLocation()});
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SAMPLE_SIZE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.sampleSize = parser.intValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", new Object[]{parser.getTokenLocation()});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
                this.query = AbstractQueryBuilder.parseTopLevelQuery((XContentParser)parser);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", new Object[]{parser.getTokenLocation()});
        }
        token = parser.nextToken();
        if (token != null) {
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token [" + token + "] found after the main object.", new Object[0]);
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.sampleSize == null) {
            validationException = ValidateActions.addValidationError((String)("[" + SAMPLE_SIZE_FIELD.getPreferredName() + "] is mandatory"), validationException);
        } else if (this.sampleSize <= 0) {
            validationException = ValidateActions.addValidationError((String)("[" + SAMPLE_SIZE_FIELD.getPreferredName() + "] must be greater or equals than 1, got: " + this.sampleSize), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, null, parentTaskId, headers){

            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                sb.append("sample_size[").append(GetStackTracesRequest.this.sampleSize).append("]");
                if (GetStackTracesRequest.this.query == null) {
                    sb.append(", query[]");
                } else {
                    sb.append(", query[").append(Strings.toString((ToXContent)GetStackTracesRequest.this.query)).append("]");
                }
                return sb.toString();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetStackTracesRequest that = (GetStackTracesRequest)((Object)o);
        return Objects.equals(this.query, that.query) && Objects.equals(this.sampleSize, that.sampleSize);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.sampleSize);
    }

    public String[] indices() {
        HashSet<String> indices = new HashSet<String>();
        indices.add("profiling-stacktraces");
        indices.add("profiling-stackframes");
        indices.add("profiling-executables");
        indices.addAll(EventsIndex.indexNames());
        return indices.toArray(new String[0]);
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.STRICT_EXPAND_OPEN;
    }

    public boolean includeDataStreams() {
        return true;
    }
}

