/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.OptionalLong;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.MachineLearning;

public final class NativeMemoryCalculator {
    public static final long STATIC_JVM_UPPER_THRESHOLD = ByteSizeValue.ofGb((long)31L).getBytes();
    public static final long MINIMUM_AUTOMATIC_NODE_SIZE = ByteSizeValue.ofMb((long)512L).getBytes();
    private static final long OS_OVERHEAD = ByteSizeValue.ofMb((long)200L).getBytes();
    public static final long JVM_SIZE_KNOT_POINT = ByteSizeValue.ofGb((long)16L).getBytes();
    private static final long BYTES_IN_4MB = ByteSizeValue.ofMb((long)4L).getBytes();
    private static final long MINIMUM_AUTOMATIC_JVM_SIZE = NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNodeSize(MINIMUM_AUTOMATIC_NODE_SIZE);

    private NativeMemoryCalculator() {
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, Settings settings) {
        if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) {
            return OptionalLong.empty();
        }
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), (int)((Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings)), (boolean)((Boolean)MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT.get(settings)));
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, ClusterSettings settings) {
        if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) {
            return OptionalLong.empty();
        }
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), (int)((Integer)settings.get(MachineLearning.MAX_MACHINE_MEMORY_PERCENT)), (boolean)((Boolean)settings.get(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT)));
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, int maxMemoryPercent, boolean useAutoPercent) {
        if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) {
            return OptionalLong.empty();
        }
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), maxMemoryPercent, useAutoPercent);
    }

    private static OptionalLong allowedBytesForMl(String nodeBytes, String jvmBytes, int maxMemoryPercent, boolean useAuto) {
        long jvmMemory;
        long machineMemory;
        assert (nodeBytes != null) : "This private method should only be called for ML nodes, and all ML nodes should have the ml.machine_memory node attribute";
        if (nodeBytes == null) {
            return OptionalLong.empty();
        }
        try {
            machineMemory = Long.parseLong(nodeBytes);
        }
        catch (NumberFormatException e) {
            assert (e == null) : "ml.machine_memory should parse because we set it internally: invalid value was " + nodeBytes;
            return OptionalLong.empty();
        }
        assert (jvmBytes != null) : "This private method should only be called for ML nodes, and all ML nodes should have the ml.max_jvm_size node attribute";
        if (jvmBytes == null) {
            return OptionalLong.empty();
        }
        try {
            jvmMemory = Long.parseLong(jvmBytes);
        }
        catch (NumberFormatException e) {
            assert (e == null) : "ml.max_jvm_size should parse because we set it internally: invalid value was " + jvmBytes;
            return OptionalLong.empty();
        }
        return OptionalLong.of(NativeMemoryCalculator.allowedBytesForMl(machineMemory, jvmMemory, maxMemoryPercent, useAuto));
    }

    public static long calculateApproxNecessaryNodeSize(long mlNativeMemoryRequirement, Long jvmSize, int maxMemoryPercent, boolean useAuto) {
        if (mlNativeMemoryRequirement == 0L) {
            return 0L;
        }
        if (useAuto) {
            jvmSize = jvmSize == null ? NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromMlNativeMemorySize(mlNativeMemoryRequirement) : jvmSize;
            return Math.max(mlNativeMemoryRequirement + jvmSize + OS_OVERHEAD, MINIMUM_AUTOMATIC_NODE_SIZE);
        }
        return (long)Math.ceil(100.0 / (double)maxMemoryPercent * (double)mlNativeMemoryRequirement);
    }

    static long allowedBytesForMl(long machineMemory, long jvmSize, int maxMemoryPercent, boolean useAuto) {
        if (machineMemory <= 0L) {
            return 0L;
        }
        if (useAuto) {
            if (machineMemory - jvmSize <= OS_OVERHEAD) {
                return machineMemory / 100L;
            }
            return Math.min(machineMemory - jvmSize - OS_OVERHEAD, machineMemory * 9L / 10L);
        }
        return machineMemory * (long)maxMemoryPercent / 100L;
    }

    public static long allowedBytesForMl(long machineMemory, int maxMemoryPercent, boolean useAuto) {
        return NativeMemoryCalculator.allowedBytesForMl(machineMemory, useAuto ? NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNodeSize(machineMemory) : Math.min(machineMemory / 2L, STATIC_JVM_UPPER_THRESHOLD), maxMemoryPercent, useAuto);
    }

    public static long dynamicallyCalculateJvmSizeFromNodeSize(long nodeSize) {
        if (nodeSize <= JVM_SIZE_KNOT_POINT) {
            return (long)((double)nodeSize * 0.4) / BYTES_IN_4MB * BYTES_IN_4MB;
        }
        return Math.min((long)((double)JVM_SIZE_KNOT_POINT * 0.4 + (double)(nodeSize - JVM_SIZE_KNOT_POINT) * 0.1) / BYTES_IN_4MB * BYTES_IN_4MB, STATIC_JVM_UPPER_THRESHOLD);
    }

    public static long dynamicallyCalculateJvmSizeFromMlNativeMemorySize(long mlNativeMemorySize) {
        long lowerAnswer;
        long nodeSizeImpliedByLowerAnswer;
        long higherAnswer;
        long nativeAndOverhead = mlNativeMemorySize + OS_OVERHEAD;
        if (nativeAndOverhead <= JVM_SIZE_KNOT_POINT - NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNodeSize(JVM_SIZE_KNOT_POINT)) {
            higherAnswer = nativeAndOverhead * 2L / 3L / BYTES_IN_4MB * BYTES_IN_4MB;
        } else {
            double nativeAndOverheadAbove16GB = (double)nativeAndOverhead - (double)JVM_SIZE_KNOT_POINT * 0.6;
            higherAnswer = (long)((double)JVM_SIZE_KNOT_POINT * 0.4 + nativeAndOverheadAbove16GB / 0.9 * 0.1) / BYTES_IN_4MB * BYTES_IN_4MB;
        }
        if (higherAnswer > BYTES_IN_4MB && NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNodeSize(nodeSizeImpliedByLowerAnswer = nativeAndOverhead + (lowerAnswer = higherAnswer - BYTES_IN_4MB)) == lowerAnswer) {
            return Math.max(MINIMUM_AUTOMATIC_JVM_SIZE, Math.min(lowerAnswer, STATIC_JVM_UPPER_THRESHOLD));
        }
        return Math.max(MINIMUM_AUTOMATIC_JVM_SIZE, Math.min(higherAnswer, STATIC_JVM_UPPER_THRESHOLD));
    }

    public static ByteSizeValue calculateMaxModelMemoryLimitToFit(ClusterSettings clusterSettings, DiscoveryNodes nodes) {
        long maxMlMemory = 0L;
        for (DiscoveryNode node : nodes) {
            OptionalLong limit = NativeMemoryCalculator.allowedBytesForMl(node, clusterSettings);
            if (limit.isEmpty()) continue;
            maxMlMemory = Math.max(maxMlMemory, limit.getAsLong());
        }
        long maxMlNodeSize = ((ByteSizeValue)clusterSettings.get(MachineLearning.MAX_ML_NODE_SIZE)).getBytes();
        int maxLazyNodes = (Integer)clusterSettings.get(MachineLearning.MAX_LAZY_ML_NODES);
        if (maxMlNodeSize > 0L && maxLazyNodes > 0) {
            maxMlMemory = Math.max(maxMlMemory, NativeMemoryCalculator.allowedBytesForMl(maxMlNodeSize, (int)((Integer)clusterSettings.get(MachineLearning.MAX_MACHINE_MEMORY_PERCENT)), (boolean)((Boolean)clusterSettings.get(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT))));
        }
        if (maxMlMemory == 0L) {
            return null;
        }
        maxMlMemory -= Math.max(Job.PROCESS_MEMORY_OVERHEAD.getBytes(), DataFrameAnalyticsConfig.PROCESS_MEMORY_OVERHEAD.getBytes());
        return ByteSizeValue.ofMb((long)ByteSizeUnit.BYTES.toMB(Math.max(0L, maxMlMemory -= MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes())));
    }

    public static ByteSizeValue calculateTotalMlMemory(ClusterSettings clusterSettings, DiscoveryNodes nodes) {
        long totalMlMemory = 0L;
        for (DiscoveryNode node : nodes) {
            OptionalLong limit = NativeMemoryCalculator.allowedBytesForMl(node, clusterSettings);
            if (limit.isEmpty()) continue;
            totalMlMemory += limit.getAsLong();
        }
        return ByteSizeValue.ofMb((long)ByteSizeUnit.BYTES.toMB(totalMlMemory));
    }

    public static ByteSizeValue getMaxModelMemoryLimit(ClusterService clusterService) {
        DiscoveryNodes nodes;
        ByteSizeValue modelMemoryLimitToFit;
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        ByteSizeValue maxModelMemoryLimit = (ByteSizeValue)clusterSettings.get(MachineLearningField.MAX_MODEL_MEMORY_LIMIT);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L) {
            return maxModelMemoryLimit;
        }
        Boolean autoMemory = (Boolean)clusterSettings.get(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT);
        if (autoMemory.booleanValue() && (modelMemoryLimitToFit = NativeMemoryCalculator.calculateMaxModelMemoryLimitToFit(clusterSettings, nodes = clusterService.state().getNodes())) != null) {
            return modelMemoryLimitToFit;
        }
        return ByteSizeValue.ZERO;
    }
}

