/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestStopTrainedModelDeploymentAction
extends BaseRestHandler {
    public String getName() {
        return "xpack_ml_stop_trained_models_deployment_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID.getPreferredName() + "}/deployment/_stop"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        StopTrainedModelDeploymentAction.Request request;
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            request = StopTrainedModelDeploymentAction.Request.parseRequest((String)modelId, (XContentParser)restRequest.contentOrSourceParamParser());
        } else {
            request = new StopTrainedModelDeploymentAction.Request(modelId);
            request.setAllowNoMatch(restRequest.paramAsBoolean(StopTrainedModelDeploymentAction.Request.ALLOW_NO_MATCH.getPreferredName(), request.isAllowNoMatch()));
            request.setForce(restRequest.paramAsBoolean(StopTrainedModelDeploymentAction.Request.FORCE.getPreferredName(), request.isForce()));
        }
        return channel -> client.execute((ActionType)StopTrainedModelDeploymentAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

