/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.filter;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetFiltersAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/filters/{" + MlFilter.ID + "}")).replaces(RestRequest.Method.GET, "/_xpack/ml/filters/{" + MlFilter.ID + "}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_ml/filters/").replaces(RestRequest.Method.GET, "/_xpack/ml/filters/", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_filters_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetFiltersAction.Request request = new GetFiltersAction.Request();
        String filterId = restRequest.param(MlFilter.ID.getPreferredName());
        if (!Strings.isNullOrEmpty((String)filterId)) {
            request.setResourceId(filterId);
        }
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)GetFiltersAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
    }
}

