/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class JobDataCountsPersister {
    private static final Logger logger = LogManager.getLogger(JobDataCountsPersister.class);
    private final ResultsPersisterService resultsPersisterService;
    private final Client client;
    private final AnomalyDetectionAuditor auditor;
    private final Map<String, CountDownLatch> ongoingPersists = new ConcurrentHashMap<String, CountDownLatch>();

    public JobDataCountsPersister(Client client, ResultsPersisterService resultsPersisterService, AnomalyDetectionAuditor auditor) {
        this.resultsPersisterService = resultsPersisterService;
        this.client = client;
        this.auditor = auditor;
    }

    private static XContentBuilder serialiseCounts(DataCounts counts) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        return counts.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public boolean persistDataCounts(String jobId, DataCounts counts, boolean mustWait) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch previousLatch = this.ongoingPersists.putIfAbsent(jobId, latch);
        while (previousLatch != null) {
            if (!mustWait) {
                return false;
            }
            previousLatch.await();
            previousLatch = this.ongoingPersists.putIfAbsent(jobId, latch);
        }
        counts.setLogTime(Instant.now());
        try {
            this.resultsPersisterService.indexWithRetry(jobId, AnomalyDetectorsIndex.resultsWriteAlias((String)jobId), (ToXContent)counts, ToXContent.EMPTY_PARAMS, WriteRequest.RefreshPolicy.NONE, DataCounts.documentId((String)jobId), true, () -> true, retryMessage -> logger.debug("[{}] Job data_counts {}", (Object)jobId, retryMessage), (ActionListener<BulkResponse>)ActionListener.wrap(r -> this.ongoingPersists.remove(jobId).countDown(), e -> {
                this.ongoingPersists.remove(jobId).countDown();
                logger.error(() -> "[" + jobId + "] Failed persisting data_counts stats", (Throwable)e);
                this.auditor.error(jobId, "Failed persisting data_counts stats: " + e.getMessage());
            }));
        }
        catch (IOException e2) {
            logger.error(() -> "[" + jobId + "] Failed writing data_counts stats", (Throwable)e2);
            return false;
        }
        if (mustWait) {
            latch.await();
        }
        return true;
    }

    public void persistDataCountsAsync(String jobId, DataCounts counts, ActionListener<Boolean> listener) {
        counts.setLogTime(Instant.now());
        try (XContentBuilder content = JobDataCountsPersister.serialiseCounts(counts);){
            IndexRequest request = ((IndexRequest)new IndexRequest(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId)).id(DataCounts.documentId((String)jobId)).setRequireAlias(true).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(content);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)request, (ActionListener)listener.safeMap(r -> true));
        }
        catch (IOException ioe) {
            String msg = "[" + jobId + "] Failed writing data_counts stats";
            logger.error(msg, (Throwable)ioe);
            listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)msg, (Throwable)ioe)));
        }
    }
}

