/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch.process;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.inference.deployment.TrainedModelDeploymentTask;
import org.elasticsearch.xpack.ml.inference.pytorch.process.NativePyTorchProcess;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchBuilder;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchProcessFactory;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class NativePyTorchProcessFactory
implements PyTorchProcessFactory {
    private static final Logger logger = LogManager.getLogger(NativePyTorchProcessFactory.class);
    private static final NamedPipeHelper NAMED_PIPE_HELPER = new NamedPipeHelper();
    private final Environment env;
    private final NativeController nativeController;
    private final String nodeName;
    private volatile Duration processConnectTimeout;

    public NativePyTorchProcessFactory(Environment env, NativeController nativeController, ClusterService clusterService) {
        this.env = Objects.requireNonNull(env);
        this.nativeController = Objects.requireNonNull(nativeController);
        this.nodeName = clusterService.getNodeName();
        this.setProcessConnectTimeout((TimeValue)MachineLearning.PROCESS_CONNECT_TIMEOUT.get(env.settings()));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.PROCESS_CONNECT_TIMEOUT, this::setProcessConnectTimeout);
    }

    void setProcessConnectTimeout(TimeValue processConnectTimeout) {
        this.processConnectTimeout = Duration.ofMillis(processConnectTimeout.getMillis());
    }

    @Override
    public NativePyTorchProcess createProcess(TrainedModelDeploymentTask task, ExecutorService executorService, Consumer<String> onProcessCrash) {
        ProcessPipes processPipes = new ProcessPipes(this.env, NAMED_PIPE_HELPER, this.processConnectTimeout, "pytorch_inference", task.getDeploymentId(), null, false, true, true, true, false);
        this.executeProcess(processPipes, task);
        NativePyTorchProcess process = new NativePyTorchProcess(task.getDeploymentId(), this.nativeController, processPipes, 0, Collections.emptyList(), onProcessCrash);
        try {
            process.start(executorService);
        }
        catch (IOException | EsRejectedExecutionException e) {
            String msg = "Failed to connect to pytorch process for job " + task.getDeploymentId();
            logger.error(msg);
            try {
                IOUtils.close((Closeable)process);
            }
            catch (IOException ioe) {
                logger.error("Can't close pytorch process", (Throwable)ioe);
            }
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
        return process;
    }

    private void executeProcess(ProcessPipes processPipes, TrainedModelDeploymentTask task) {
        PyTorchBuilder pyTorchBuilder = new PyTorchBuilder(this.nativeController, processPipes, task.getParams());
        try {
            pyTorchBuilder.build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted while launching PyTorch process");
        }
        catch (IOException e) {
            String msg = "Failed to launch PyTorch process";
            logger.error(msg);
            throw ExceptionsHelper.serverError((String)(msg + " on [" + this.nodeName + "]"), (Throwable)e);
        }
    }
}

