/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregatedSearchRequestBuilder;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationToJsonProcessor;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.CompositeAggregationDataExtractorContext;

class CompositeAggregationDataExtractor
implements DataExtractor {
    private static final Logger LOGGER = LogManager.getLogger(CompositeAggregationDataExtractor.class);
    private volatile Map<String, Object> afterKey = null;
    private final CompositeAggregationBuilder compositeAggregationBuilder;
    private final Client client;
    private final CompositeAggregationDataExtractorContext context;
    private final DatafeedTimingStatsReporter timingStatsReporter;
    private final AggregatedSearchRequestBuilder requestBuilder;
    private final long interval;
    private volatile boolean isCancelled;
    private volatile long nextBucketOnCancel;
    private boolean hasNext;

    CompositeAggregationDataExtractor(CompositeAggregationBuilder compositeAggregationBuilder, Client client, CompositeAggregationDataExtractorContext dataExtractorContext, DatafeedTimingStatsReporter timingStatsReporter, AggregatedSearchRequestBuilder requestBuilder) {
        this.compositeAggregationBuilder = Objects.requireNonNull(compositeAggregationBuilder);
        this.client = Objects.requireNonNull(client);
        this.context = Objects.requireNonNull(dataExtractorContext);
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
        this.requestBuilder = Objects.requireNonNull(requestBuilder);
        this.interval = ExtractorUtils.getHistogramIntervalMillis((AggregationBuilder)compositeAggregationBuilder);
        this.hasNext = true;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        LOGGER.debug(() -> "[" + this.context.jobId + "] Data extractor received cancel request");
        this.isCancelled = true;
    }

    public long getEndTime() {
        return this.context.end;
    }

    public DataExtractor.Result next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SearchInterval searchInterval = new SearchInterval(this.context.start, this.context.end);
        Aggregations aggs = this.search();
        if (aggs == null) {
            LOGGER.trace(() -> "[" + this.context.jobId + "] extraction finished");
            this.hasNext = false;
            this.afterKey = null;
            return new DataExtractor.Result(searchInterval, Optional.empty());
        }
        return new DataExtractor.Result(searchInterval, Optional.of(this.processAggs(aggs)));
    }

    private Aggregations search() {
        LOGGER.trace(() -> Strings.format((String)"[%s] Executing composite aggregated search from [%s] to [%s]", (Object[])new Object[]{this.context.jobId, this.context.start, this.context.end}));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query(ExtractorUtils.wrapInTimeRangeQuery((QueryBuilder)this.context.query, (String)this.context.timeField, (long)this.context.start, (long)this.context.end));
        if (!this.context.runtimeMappings.isEmpty()) {
            searchSourceBuilder.runtimeMappings(this.context.runtimeMappings);
        }
        if (this.afterKey != null) {
            this.compositeAggregationBuilder.aggregateAfter(this.afterKey);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)this.compositeAggregationBuilder);
        ActionRequestBuilder<SearchRequest, SearchResponse> searchRequest = this.requestBuilder.build(searchSourceBuilder);
        SearchResponse searchResponse = this.executeSearchRequest(searchRequest);
        LOGGER.trace(() -> "[" + this.context.jobId + "] Search composite response was obtained");
        this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return null;
        }
        CompositeAggregation compositeAgg = (CompositeAggregation)aggregations.get(this.compositeAggregationBuilder.getName());
        if (compositeAgg == null || compositeAgg.getBuckets().isEmpty()) {
            return null;
        }
        return aggregations;
    }

    protected SearchResponse executeSearchRequest(ActionRequestBuilder<SearchRequest, SearchResponse> searchRequestBuilder) {
        SearchResponse searchResponse = (SearchResponse)ClientHelper.executeWithHeaders(this.context.headers, (String)"ml", (Client)this.client, () -> searchRequestBuilder.get());
        this.checkForSkippedClusters(searchResponse);
        return searchResponse;
    }

    private InputStream processAggs(Aggregations aggs) throws IOException {
        AggregationToJsonProcessor aggregationToJsonProcessor = new AggregationToJsonProcessor(this.context.timeField, this.context.fields, this.context.includeDocCount, this.context.start, this.context.compositeAggDateHistogramGroupSourceName);
        LOGGER.trace(() -> Strings.format((String)"[%s] got [%s] composite buckets", (Object[])new Object[]{this.context.jobId, ((CompositeAggregation)aggs.get(this.compositeAggregationBuilder.getName())).getBuckets().size()}));
        aggregationToJsonProcessor.process(aggs);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Long afterKeyTimeBucket = this.afterKey != null ? (Long)this.afterKey.get(this.context.compositeAggDateHistogramGroupSourceName) : null;
        boolean cancellable = aggregationToJsonProcessor.writeAllDocsCancellable(timestamp -> {
            if (this.isCancelled) {
                if (afterKeyTimeBucket == null) {
                    return true;
                }
                if (this.nextBucketOnCancel == 0L) {
                    this.nextBucketOnCancel = Intervals.alignToFloor((long)(timestamp + this.interval), (long)this.interval);
                    LOGGER.debug(() -> Strings.format((String)"[%s] set future timestamp cancel to [%s] via timestamp [%s]", (Object[])new Object[]{this.context.jobId, this.nextBucketOnCancel, timestamp}));
                }
                return timestamp >= this.nextBucketOnCancel;
            }
            return false;
        }, outputStream);
        if (this.isCancelled && cancellable) {
            LOGGER.debug(() -> Strings.format((String)"[%s] cancelled before bucket [%s] on date_histogram page [%s]", (Object[])new Object[]{this.context.jobId, this.nextBucketOnCancel, afterKeyTimeBucket != null ? afterKeyTimeBucket : "__null__"}));
            this.hasNext = false;
        }
        CompositeAggregation compositeAgg = (CompositeAggregation)aggs.get(this.compositeAggregationBuilder.getName());
        this.afterKey = compositeAgg.afterKey();
        return new ByteArrayInputStream(outputStream.toByteArray());
    }
}

