/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedUpdate;
import org.elasticsearch.xpack.ml.MlAutoUpdateService;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;

public class DatafeedConfigAutoUpdater
implements MlAutoUpdateService.UpdateAction {
    private static final Logger logger = LogManager.getLogger(DatafeedConfigAutoUpdater.class);
    private final DatafeedConfigProvider provider;
    private final IndexNameExpressionResolver expressionResolver;

    public DatafeedConfigAutoUpdater(DatafeedConfigProvider provider, IndexNameExpressionResolver expressionResolver) {
        this.provider = provider;
        this.expressionResolver = expressionResolver;
    }

    @Override
    public boolean isMinTransportVersionSupported(TransportVersion minNodeVersion) {
        return minNodeVersion.onOrAfter((VersionId)TransportVersion.V_8_0_0);
    }

    @Override
    public boolean isAbleToRun(ClusterState latestState) {
        String[] indices;
        for (String index : indices = this.expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), new String[]{MlConfigIndex.indexName()})) {
            IndexRoutingTable routingTable;
            if (!latestState.metadata().hasIndex(index) || (routingTable = latestState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "datafeed_aggs_updater";
    }

    @Override
    public void runUpdate() {
        PlainActionFuture getdatafeeds = PlainActionFuture.newFuture();
        this.provider.expandDatafeedConfigs("_all", true, null, (ActionListener<List<DatafeedConfig.Builder>>)getdatafeeds);
        List datafeedConfigBuilders = (List)getdatafeeds.actionGet();
        List<DatafeedUpdate> updates = datafeedConfigBuilders.stream().map(DatafeedConfig.Builder::build).filter(DatafeedConfig::aggsRewritten).map(datafeedConfig -> new DatafeedUpdate.Builder().setAggregations(datafeedConfig.getAggProvider()).setId(datafeedConfig.getId()).build()).toList();
        if (updates.isEmpty()) {
            return;
        }
        logger.debug(() -> Strings.format((String)"%s datafeeds are currently being updated", (Object[])new Object[]{updates.stream().map(DatafeedUpdate::getId).collect(Collectors.toList())}));
        ArrayList<ElasticsearchException> failures = new ArrayList<ElasticsearchException>();
        for (DatafeedUpdate update : updates) {
            PlainActionFuture updateDatafeeds = PlainActionFuture.newFuture();
            this.provider.updateDatefeedConfig(update.getId(), update, Collections.emptyMap(), (updatedConfig, listener) -> listener.onResponse((Object)Boolean.TRUE), (ActionListener<DatafeedConfig>)updateDatafeeds);
            try {
                updateDatafeeds.actionGet();
                logger.debug(() -> "[" + update.getId() + "] datafeed successfully updated");
            }
            catch (Exception ex) {
                logger.warn(() -> "[" + update.getId() + "] failed being updated", (Throwable)ex);
                failures.add(new ElasticsearchException("Failed to update datafeed {}", (Throwable)ex, new Object[]{update.getId()}));
            }
        }
        if (failures.isEmpty()) {
            logger.debug(() -> Strings.format((String)"%s datafeeds are finished being updated", (Object[])new Object[]{updates.stream().map(DatafeedUpdate::getId).collect(Collectors.toList())}));
            return;
        }
        ElasticsearchException exception = new ElasticsearchException("some datafeeds failed being upgraded.", new Object[0]);
        failures.forEach(exception::addSuppressed);
        throw exception;
    }
}

