/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.correlation;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricsPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;
import org.elasticsearch.xpack.ml.aggs.correlation.BucketCorrelationAggregator;
import org.elasticsearch.xpack.ml.aggs.correlation.CorrelationFunction;

public class BucketCorrelationAggregationBuilder
extends BucketMetricsPipelineAggregationBuilder<BucketCorrelationAggregationBuilder> {
    public static final ParseField NAME = new ParseField("bucket_correlation", new String[0]);
    private static final ParseField FUNCTION = new ParseField("function", new String[0]);
    public static final ConstructingObjectParser<BucketCorrelationAggregationBuilder, String> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), false, (args, context) -> new BucketCorrelationAggregationBuilder((String)context, (String)args[0], (CorrelationFunction)args[1], (BucketHelpers.GapPolicy)args[2]));
    private final CorrelationFunction correlationFunction;

    public BucketCorrelationAggregationBuilder(String name, String bucketsPath, CorrelationFunction correlationFunction) {
        this(name, bucketsPath, correlationFunction, BucketHelpers.GapPolicy.INSERT_ZEROS);
    }

    private BucketCorrelationAggregationBuilder(String name, String bucketsPath, CorrelationFunction correlationFunction, BucketHelpers.GapPolicy gapPolicy) {
        super(name, NAME.getPreferredName(), new String[]{bucketsPath}, null, gapPolicy == null ? BucketHelpers.GapPolicy.INSERT_ZEROS : gapPolicy);
        this.correlationFunction = correlationFunction;
        if (gapPolicy != null && !gapPolicy.equals((Object)BucketHelpers.GapPolicy.INSERT_ZEROS)) {
            throw new IllegalArgumentException("only [gap_policy] of [" + BucketHelpers.GapPolicy.INSERT_ZEROS.getName() + "] is supported");
        }
    }

    public BucketCorrelationAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME.getPreferredName());
        this.correlationFunction = (CorrelationFunction)in.readNamedWriteable(CorrelationFunction.class);
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.correlationFunction);
    }

    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new BucketCorrelationAggregator(this.name, this.correlationFunction, this.bucketsPaths[0], metadata);
    }

    protected boolean overrideBucketsPath() {
        return true;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(BUCKETS_PATH_FIELD.getPreferredName(), this.bucketsPaths[0]);
        NamedXContentObjectHelper.writeNamedObject((XContentBuilder)builder, (ToXContent.Params)params, (String)FUNCTION.getPreferredName(), (NamedXContentObject)this.correlationFunction);
        return builder;
    }

    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        super.validate(context);
        this.correlationFunction.validate(context, this.bucketsPaths[0]);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        BucketCorrelationAggregationBuilder that = (BucketCorrelationAggregationBuilder)((Object)o);
        return Objects.equals(this.correlationFunction, that.correlationFunction);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.correlationFunction);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.V_7_14_0;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (p, c, n) -> (CorrelationFunction)p.namedObject(CorrelationFunction.class, n, null), FUNCTION);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return BucketHelpers.GapPolicy.parse((String)p.text().toLowerCase(Locale.ROOT), (XContentLocation)p.getTokenLocation());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, PipelineAggregator.Parser.GAP_POLICY, ObjectParser.ValueType.STRING);
    }
}

