/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentClusterService;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportUpdateTrainedModelDeploymentAction
extends TransportMasterNodeAction<UpdateTrainedModelDeploymentAction.Request, CreateTrainedModelAssignmentAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateTrainedModelDeploymentAction.class);
    private final TrainedModelAssignmentClusterService trainedModelAssignmentClusterService;
    private final InferenceAuditor auditor;

    @Inject
    public TransportUpdateTrainedModelDeploymentAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TrainedModelAssignmentClusterService trainedModelAssignmentClusterService, InferenceAuditor auditor) {
        super("cluster:admin/xpack/ml/trained_models/deployment/update", transportService, clusterService, threadPool, actionFilters, UpdateTrainedModelDeploymentAction.Request::new, indexNameExpressionResolver, CreateTrainedModelAssignmentAction.Response::new, "same");
        this.trainedModelAssignmentClusterService = Objects.requireNonNull(trainedModelAssignmentClusterService);
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected void masterOperation(Task task, UpdateTrainedModelDeploymentAction.Request request, ClusterState state, ActionListener<CreateTrainedModelAssignmentAction.Response> listener) throws Exception {
        logger.debug(() -> Strings.format((String)"[%s] received request to update number of allocations to [%s]", (Object[])new Object[]{request.getDeploymentId(), request.getNumberOfAllocations()}));
        this.trainedModelAssignmentClusterService.updateNumberOfAllocations(request.getDeploymentId(), request.getNumberOfAllocations(), (ActionListener<TrainedModelAssignment>)ActionListener.wrap(updatedAssignment -> {
            this.auditor.info(request.getDeploymentId(), Messages.getMessage((String)"Updated number_of_allocations to [{0}]", (Object[])new Object[]{request.getNumberOfAllocations()}));
            listener.onResponse((Object)new CreateTrainedModelAssignmentAction.Response(updatedAssignment));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(UpdateTrainedModelDeploymentAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

