/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Strings;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedRunningStateAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;

public class TransportGetDatafeedRunningStateAction
extends TransportTasksAction<TransportStartDatafeedAction.DatafeedTask, GetDatafeedRunningStateAction.Request, GetDatafeedRunningStateAction.Response, GetDatafeedRunningStateAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDatafeedRunningStateAction.class);

    @Inject
    public TransportGetDatafeedRunningStateAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters) {
        super("cluster:internal/xpack/ml/datafeed/running_state", clusterService, transportService, actionFilters, GetDatafeedRunningStateAction.Request::new, GetDatafeedRunningStateAction.Response::new, GetDatafeedRunningStateAction.Response::new, "management");
    }

    protected GetDatafeedRunningStateAction.Response newResponse(GetDatafeedRunningStateAction.Request request, List<GetDatafeedRunningStateAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        ExceptionsHelper.rethrowAndSuppress(taskOperationFailures.stream().map(t -> ExceptionsHelper.convertToElastic((Exception)t.getCause())).collect(Collectors.toList()));
        ExceptionsHelper.rethrowAndSuppress(failedNodeExceptions);
        return GetDatafeedRunningStateAction.Response.fromResponses(tasks);
    }

    protected void taskOperation(CancellableTask actionTask, GetDatafeedRunningStateAction.Request request, TransportStartDatafeedAction.DatafeedTask datafeedTask, ActionListener<GetDatafeedRunningStateAction.Response> listener) {
        listener.onResponse((Object)GetDatafeedRunningStateAction.Response.fromTaskAndState((String)datafeedTask.getDatafeedId(), (GetDatafeedRunningStateAction.Response.RunningState)datafeedTask.getRunningState()));
    }

    protected void doExecute(Task task, GetDatafeedRunningStateAction.Request request, ActionListener<GetDatafeedRunningStateAction.Response> listener) {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)this.clusterService.state().getMetadata().custom("persistent_tasks");
        if (tasks == null) {
            listener.onResponse((Object)new GetDatafeedRunningStateAction.Response(Collections.emptyMap()));
            return;
        }
        List datafeedTasks = request.getDatafeedTaskIds().stream().map(arg_0 -> ((PersistentTasksCustomMetadata)tasks).getTask(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (datafeedTasks.isEmpty()) {
            listener.onResponse((Object)new GetDatafeedRunningStateAction.Response(Collections.emptyMap()));
            return;
        }
        ActionListener taskResponseListener = ActionListener.wrap(actionResponses -> {
            Map runningStateMap = actionResponses.getDatafeedRunningState();
            if (runningStateMap.size() == datafeedTasks.size()) {
                listener.onResponse(actionResponses);
                return;
            }
            ArrayList<GetDatafeedRunningStateAction.Response> missingResponses = new ArrayList<GetDatafeedRunningStateAction.Response>();
            missingResponses.add((GetDatafeedRunningStateAction.Response)actionResponses);
            missingResponses.add(new GetDatafeedRunningStateAction.Response(datafeedTasks.stream().map(t -> (StartDatafeedAction.DatafeedParams)t.getParams()).filter(datafeedParams -> !runningStateMap.containsKey(datafeedParams.getDatafeedId())).collect(Collectors.toMap(StartDatafeedAction.DatafeedParams::getDatafeedId, params -> new GetDatafeedRunningStateAction.Response.RunningState(params.getEndTime() == null, false, null)))));
            listener.onResponse((Object)GetDatafeedRunningStateAction.Response.fromResponses(missingResponses));
        }, arg_0 -> listener.onFailure(arg_0));
        String[] nodesOfConcern = (String[])datafeedTasks.stream().map(PersistentTasksCustomMetadata.PersistentTask::getExecutorNode).filter(Objects::nonNull).filter(arg_0 -> ((DiscoveryNodes)nodes).nodeExists(arg_0)).toArray(String[]::new);
        if (nodesOfConcern.length == 0) {
            logger.debug(() -> Strings.format((String)"Unable to find executor nodes for datafeed tasks %s", (Object[])new Object[]{request.getDatafeedTaskIds()}));
            taskResponseListener.onResponse((Object)new GetDatafeedRunningStateAction.Response(Collections.emptyMap()));
            return;
        }
        request.setNodes(nodesOfConcern);
        super.doExecute(task, (BaseTasksRequest)request, taskResponseListener);
    }
}

