/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentClusterService;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentNodeService;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentService;
import org.elasticsearch.xpack.ml.inference.deployment.DeploymentManager;

public class TransportCreateTrainedModelAssignmentAction
extends TransportMasterNodeAction<CreateTrainedModelAssignmentAction.Request, CreateTrainedModelAssignmentAction.Response> {
    private final TrainedModelAssignmentClusterService trainedModelAssignmentClusterService;

    @Inject
    public TransportCreateTrainedModelAssignmentAction(TrainedModelAssignmentClusterService trainedModelAssignmentClusterService, TrainedModelAssignmentService trainedModelAssignmentService, DeploymentManager deploymentManager, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState) {
        super("cluster:internal/xpack/ml/model_allocation/create", false, transportService, clusterService, threadPool, actionFilters, CreateTrainedModelAssignmentAction.Request::new, indexNameExpressionResolver, CreateTrainedModelAssignmentAction.Response::new, "same");
        this.trainedModelAssignmentClusterService = trainedModelAssignmentClusterService;
        clusterService.addListener((ClusterStateListener)new TrainedModelAssignmentNodeService(trainedModelAssignmentService, clusterService, deploymentManager, indexNameExpressionResolver, transportService.getTaskManager(), threadPool, licenseState));
    }

    protected void masterOperation(Task task, CreateTrainedModelAssignmentAction.Request request, ClusterState state, ActionListener<CreateTrainedModelAssignmentAction.Response> listener) throws Exception {
        this.trainedModelAssignmentClusterService.createNewModelAssignment(request.getTaskParams(), (ActionListener<TrainedModelAssignment>)ActionListener.wrap(trainedModelAssignment -> listener.onResponse((Object)new CreateTrainedModelAssignmentAction.Response(trainedModelAssignment)), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(CreateTrainedModelAssignmentAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

