/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.CancelJobModelSnapshotUpgradeAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;

public class TransportCancelJobModelSnapshotUpgradeAction
extends HandledTransportAction<CancelJobModelSnapshotUpgradeAction.Request, CancelJobModelSnapshotUpgradeAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportCancelJobModelSnapshotUpgradeAction.class);
    private final JobConfigProvider jobConfigProvider;
    private final ClusterService clusterService;
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportCancelJobModelSnapshotUpgradeAction(TransportService transportService, ActionFilters actionFilters, JobConfigProvider jobConfigProvider, ClusterService clusterService, PersistentTasksService persistentTasksService) {
        super("cluster:admin/xpack/ml/job/model_snapshots/upgrade/cancel", transportService, actionFilters, CancelJobModelSnapshotUpgradeAction.Request::new);
        this.jobConfigProvider = jobConfigProvider;
        this.clusterService = clusterService;
        this.persistentTasksService = persistentTasksService;
    }

    public void doExecute(Task task, CancelJobModelSnapshotUpgradeAction.Request request, ActionListener<CancelJobModelSnapshotUpgradeAction.Response> listener) {
        logger.debug("[{}] cancel model snapshot [{}] upgrades", (Object)request.getJobId(), (Object)request.getSnapshotId());
        ActionListener expandIdsListener = ActionListener.wrap(jobs -> {
            ExpandedIdsMatcher.SimpleIdsMatcher matcher = new ExpandedIdsMatcher.SimpleIdsMatcher(request.getSnapshotId());
            Set jobIds = jobs.stream().map(Job.Builder::getId).collect(Collectors.toSet());
            PersistentTasksCustomMetadata tasksInProgress = (PersistentTasksCustomMetadata)this.clusterService.state().metadata().custom("persistent_tasks");
            List<PersistentTasksCustomMetadata.PersistentTask<?>> upgradeTasksToCancel = MlTasks.snapshotUpgradeTasks((PersistentTasksCustomMetadata)tasksInProgress).stream().filter(t -> jobIds.contains(((SnapshotUpgradeTaskParams)t.getParams()).getJobId())).filter(t -> matcher.idMatches(((SnapshotUpgradeTaskParams)t.getParams()).getSnapshotId())).collect(Collectors.toList());
            this.removePersistentTasks(request, upgradeTasksToCancel, listener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobConfigProvider.expandJobs(request.getJobId(), request.allowNoMatch(), false, null, (ActionListener<List<Job.Builder>>)expandIdsListener);
    }

    private void removePersistentTasks(final CancelJobModelSnapshotUpgradeAction.Request request, List<PersistentTasksCustomMetadata.PersistentTask<?>> upgradeTasksToCancel, final ActionListener<CancelJobModelSnapshotUpgradeAction.Response> listener) {
        final int numberOfTasks = upgradeTasksToCancel.size();
        if (numberOfTasks == 0) {
            listener.onResponse((Object)new CancelJobModelSnapshotUpgradeAction.Response(true));
            return;
        }
        final AtomicInteger counter = new AtomicInteger();
        final AtomicArray failures = new AtomicArray(numberOfTasks);
        for (PersistentTasksCustomMetadata.PersistentTask<?> task : upgradeTasksToCancel) {
            this.persistentTasksService.sendRemoveRequest(task.getId(), new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                    if (counter.incrementAndGet() == numberOfTasks) {
                        this.sendResponseOrFailure((ActionListener<CancelJobModelSnapshotUpgradeAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                public void onFailure(Exception e) {
                    int slot = counter.incrementAndGet();
                    if (!(ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException)) {
                        failures.set(slot - 1, (Object)e);
                    }
                    if (slot == numberOfTasks) {
                        this.sendResponseOrFailure((ActionListener<CancelJobModelSnapshotUpgradeAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                private void sendResponseOrFailure(ActionListener<CancelJobModelSnapshotUpgradeAction.Response> listener2, AtomicArray<Exception> failures2) {
                    List caughtExceptions = failures2.asList();
                    if (caughtExceptions.isEmpty()) {
                        listener2.onResponse((Object)new CancelJobModelSnapshotUpgradeAction.Response(true));
                        return;
                    }
                    String msg = "Failed to cancel model snapshot upgrade for [" + request.getSnapshotId() + "] on job [" + request.getJobId() + "]. Total failures [" + caughtExceptions.size() + "], rethrowing first, all Exceptions: [" + caughtExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
                    ElasticsearchException e = new ElasticsearchException(msg, (Throwable)caughtExceptions.get(0), new Object[0]);
                    listener2.onFailure((Exception)((Object)e));
                }
            });
        }
    }
}

