/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.Counter;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MachineLearningFeatureSetUsage;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.MemoryUsage;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.assignment.AssignmentStats;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.core.ml.stats.StatsAccumulator;
import org.elasticsearch.xpack.ml.DefaultMachineLearningExtension;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MachineLearningExtension;
import org.elasticsearch.xpack.ml.MachineLearningExtensionHolder;
import org.elasticsearch.xpack.ml.job.JobManagerHolder;

public class MachineLearningUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private static final Logger logger = LogManager.getLogger(MachineLearningUsageTransportAction.class);
    private final Client client;
    private final XPackLicenseState licenseState;
    private final JobManagerHolder jobManagerHolder;
    private final MachineLearningExtension machineLearningExtension;
    private final boolean enabled;

    @Inject
    public MachineLearningUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Environment environment, Client client, XPackLicenseState licenseState, JobManagerHolder jobManagerHolder, MachineLearningExtensionHolder machineLearningExtensionHolder) {
        super(XPackUsageFeatureAction.MACHINE_LEARNING.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.client = new OriginSettingClient(client, "ml");
        this.licenseState = licenseState;
        this.jobManagerHolder = jobManagerHolder;
        this.machineLearningExtension = machineLearningExtensionHolder.isEmpty() ? new DefaultMachineLearningExtension() : machineLearningExtensionHolder.getMachineLearningExtension();
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(environment.settings());
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        if (!this.enabled) {
            MachineLearningFeatureSetUsage usage = new MachineLearningFeatureSetUsage(MachineLearningField.ML_API_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0);
            listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)usage));
            return;
        }
        LinkedHashMap jobsUsage = new LinkedHashMap();
        LinkedHashMap datafeedsUsage = new LinkedHashMap();
        LinkedHashMap analyticsUsage = new LinkedHashMap();
        int nodeCount = MachineLearningUsageTransportAction.mlNodeCount(state);
        ActionListener inferenceUsageListener = ActionListener.wrap(inferenceUsage -> listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)new MachineLearningFeatureSetUsage(MachineLearningField.ML_API_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, jobsUsage, datafeedsUsage, analyticsUsage, inferenceUsage, nodeCount))), e -> {
            logger.warn("Failed to get inference usage to include in ML usage", (Throwable)e);
            listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)new MachineLearningFeatureSetUsage(MachineLearningField.ML_API_FEATURE.checkWithoutTracking(this.licenseState), this.enabled, jobsUsage, datafeedsUsage, analyticsUsage, Collections.emptyMap(), nodeCount)));
        });
        ActionListener dataframeAnalyticsListener = ActionListener.wrap(response -> {
            this.addDataFrameAnalyticsUsage((GetDataFrameAnalyticsAction.Response)response, analyticsUsage);
            this.addInferenceUsage((ActionListener<Map<String, Object>>)inferenceUsageListener);
        }, e -> {
            logger.warn("Failed to get data frame analytics configs to include in ML usage", (Throwable)e);
            this.addInferenceUsage((ActionListener<Map<String, Object>>)inferenceUsageListener);
        });
        GetDataFrameAnalyticsAction.Request getDfaRequest = new GetDataFrameAnalyticsAction.Request("_all");
        getDfaRequest.setPageParams(new PageParams(0, 10000));
        ActionListener dataframeAnalyticsStatsListener = ActionListener.wrap(response -> {
            this.addDataFrameAnalyticsStatsUsage((GetDataFrameAnalyticsStatsAction.Response)response, analyticsUsage);
            this.client.execute((ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)getDfaRequest, dataframeAnalyticsListener);
        }, e -> {
            logger.warn("Failed to get data frame analytics stats to include in ML usage", (Throwable)e);
            this.client.execute((ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)getDfaRequest, dataframeAnalyticsListener);
        });
        GetDataFrameAnalyticsStatsAction.Request dataframeAnalyticsStatsRequest = new GetDataFrameAnalyticsStatsAction.Request("_all");
        dataframeAnalyticsStatsRequest.setPageParams(new PageParams(0, 10000));
        ActionListener datafeedStatsListener = ActionListener.wrap(response -> {
            this.addDatafeedsUsage((GetDatafeedsStatsAction.Response)response, datafeedsUsage);
            if (this.machineLearningExtension.isDataFrameAnalyticsEnabled()) {
                this.client.execute((ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, (ActionRequest)dataframeAnalyticsStatsRequest, dataframeAnalyticsStatsListener);
            } else {
                this.addInferenceUsage((ActionListener<Map<String, Object>>)inferenceUsageListener);
            }
        }, e -> {
            logger.warn("Failed to get datafeed stats to include in ML usage", (Throwable)e);
            if (this.machineLearningExtension.isDataFrameAnalyticsEnabled()) {
                this.client.execute((ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, (ActionRequest)dataframeAnalyticsStatsRequest, dataframeAnalyticsStatsListener);
            } else {
                this.addInferenceUsage((ActionListener<Map<String, Object>>)inferenceUsageListener);
            }
        });
        GetDatafeedsStatsAction.Request datafeedStatsRequest = new GetDatafeedsStatsAction.Request("_all");
        ActionListener jobStatsListener = ActionListener.wrap(response -> this.jobManagerHolder.getJobManager().expandJobs("_all", true, (ActionListener<QueryPage<Job>>)ActionListener.wrap(jobs -> {
            this.addJobsUsage((GetJobsStatsAction.Response)response, jobs.results(), jobsUsage);
            this.client.execute((ActionType)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)datafeedStatsRequest, datafeedStatsListener);
        }, e -> {
            logger.warn("Failed to get job configs to include in ML usage", (Throwable)e);
            this.client.execute((ActionType)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)datafeedStatsRequest, datafeedStatsListener);
        })), e -> {
            logger.warn("Failed to get job stats to include in ML usage", (Throwable)e);
            this.client.execute((ActionType)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)datafeedStatsRequest, datafeedStatsListener);
        });
        if (this.machineLearningExtension.isAnomalyDetectionEnabled()) {
            GetJobsStatsAction.Request jobStatsRequest = new GetJobsStatsAction.Request("_all");
            this.client.execute((ActionType)GetJobsStatsAction.INSTANCE, (ActionRequest)jobStatsRequest, jobStatsListener);
        } else if (this.machineLearningExtension.isDataFrameAnalyticsEnabled()) {
            this.client.execute((ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, (ActionRequest)dataframeAnalyticsStatsRequest, dataframeAnalyticsStatsListener);
        } else {
            this.addInferenceUsage((ActionListener<Map<String, Object>>)inferenceUsageListener);
        }
    }

    private void addJobsUsage(GetJobsStatsAction.Response response, List<Job> jobs, Map<String, Object> jobsUsage) {
        StatsAccumulator allJobsDetectorsStats = new StatsAccumulator();
        StatsAccumulator allJobsModelSizeStats = new StatsAccumulator();
        ForecastStats allJobsForecastStats = new ForecastStats();
        HashMap<JobState, Counter> jobCountByState = new HashMap<JobState, Counter>();
        HashMap<JobState, StatsAccumulator> detectorStatsByState = new HashMap<JobState, StatsAccumulator>();
        HashMap<JobState, StatsAccumulator> modelSizeStatsByState = new HashMap<JobState, StatsAccumulator>();
        HashMap<JobState, ForecastStats> forecastStatsByState = new HashMap<JobState, ForecastStats>();
        HashMap<JobState, Map> createdByByState = new HashMap<JobState, Map>();
        List jobsStats = response.getResponse().results();
        Map<String, Job> jobMap = jobs.stream().collect(Collectors.toMap(Job::getId, item -> item));
        Map<String, Long> allJobsCreatedBy = jobs.stream().map(this::jobCreatedBy).collect(Collectors.groupingBy(item -> item, Collectors.counting()));
        for (GetJobsStatsAction.Response.JobStats jobStats : jobsStats) {
            Job job = jobMap.get(jobStats.getJobId());
            if (job == null) continue;
            int detectorsCount = job.getAnalysisConfig().getDetectors().size();
            ModelSizeStats modelSizeStats = jobStats.getModelSizeStats();
            double modelSize = modelSizeStats == null ? 0.0 : (double)jobStats.getModelSizeStats().getModelBytes();
            allJobsForecastStats.merge(jobStats.getForecastStats());
            allJobsDetectorsStats.add((double)detectorsCount);
            allJobsModelSizeStats.add(modelSize);
            JobState jobState = jobStats.getState();
            jobCountByState.computeIfAbsent(jobState, js -> Counter.newCounter()).addAndGet(1L);
            detectorStatsByState.computeIfAbsent(jobState, js -> new StatsAccumulator()).add((double)detectorsCount);
            modelSizeStatsByState.computeIfAbsent(jobState, js -> new StatsAccumulator()).add(modelSize);
            forecastStatsByState.merge(jobState, jobStats.getForecastStats(), ForecastStats::merge);
            createdByByState.computeIfAbsent(jobState, js -> new HashMap()).compute(this.jobCreatedBy(job), (k, v) -> v == null ? 1L : v + 1L);
        }
        jobsUsage.put("_all", this.createJobUsageEntry(jobs.size(), allJobsDetectorsStats, allJobsModelSizeStats, allJobsForecastStats, allJobsCreatedBy));
        for (JobState jobState : jobCountByState.keySet()) {
            jobsUsage.put(jobState.name().toLowerCase(Locale.ROOT), this.createJobUsageEntry(((Counter)jobCountByState.get(jobState)).get(), (StatsAccumulator)detectorStatsByState.get(jobState), (StatsAccumulator)modelSizeStatsByState.get(jobState), (ForecastStats)forecastStatsByState.get(jobState), (Map)createdByByState.get(jobState)));
        }
    }

    private String jobCreatedBy(Job job) {
        Map customSettings = job.getCustomSettings();
        if (customSettings == null || !customSettings.containsKey("created_by")) {
            return "unknown";
        }
        return customSettings.get("created_by").toString().replaceAll("\\W", "_");
    }

    private Map<String, Object> createJobUsageEntry(long count, StatsAccumulator detectorStats, StatsAccumulator modelSizeStats, ForecastStats forecastStats, Map<String, Long> createdBy) {
        HashMap<String, Object> usage = new HashMap<String, Object>();
        usage.put("count", count);
        usage.put("detectors", detectorStats.asMap());
        usage.put("model_size", modelSizeStats.asMap());
        usage.put("forecasts", forecastStats.asMap());
        usage.put("created_by", createdBy);
        return usage;
    }

    private void addDatafeedsUsage(GetDatafeedsStatsAction.Response response, Map<String, Object> datafeedsUsage) {
        HashMap<DatafeedState, Counter> datafeedCountByState = new HashMap<DatafeedState, Counter>();
        List datafeedsStats = response.getResponse().results();
        for (GetDatafeedsStatsAction.Response.DatafeedStats datafeedStats : datafeedsStats) {
            datafeedCountByState.computeIfAbsent(datafeedStats.getDatafeedState(), ds -> Counter.newCounter()).addAndGet(1L);
        }
        datafeedsUsage.put("_all", this.createCountUsageEntry(response.getResponse().count()));
        for (DatafeedState datafeedState : datafeedCountByState.keySet()) {
            datafeedsUsage.put(datafeedState.name().toLowerCase(Locale.ROOT), this.createCountUsageEntry(((Counter)datafeedCountByState.get(datafeedState)).get()));
        }
    }

    private Map<String, Object> createCountUsageEntry(long count) {
        HashMap<String, Object> usage = new HashMap<String, Object>();
        usage.put("count", count);
        return usage;
    }

    private void addDataFrameAnalyticsStatsUsage(GetDataFrameAnalyticsStatsAction.Response response, Map<String, Object> dataframeAnalyticsUsage) {
        HashMap<DataFrameAnalyticsState, Counter> dataFrameAnalyticsStateCounterMap = new HashMap<DataFrameAnalyticsState, Counter>();
        StatsAccumulator memoryUsagePeakBytesStats = new StatsAccumulator();
        for (GetDataFrameAnalyticsStatsAction.Response.Stats stats : response.getResponse().results()) {
            dataFrameAnalyticsStateCounterMap.computeIfAbsent(stats.getState(), ds -> Counter.newCounter()).addAndGet(1L);
            MemoryUsage memoryUsage = stats.getMemoryUsage();
            if (memoryUsage == null || memoryUsage.getPeakUsageBytes() <= 0L) continue;
            memoryUsagePeakBytesStats.add((double)memoryUsage.getPeakUsageBytes());
        }
        dataframeAnalyticsUsage.put("memory_usage", Collections.singletonMap(MemoryUsage.PEAK_USAGE_BYTES.getPreferredName(), memoryUsagePeakBytesStats.asMap()));
        dataframeAnalyticsUsage.put("_all", this.createCountUsageEntry(response.getResponse().count()));
        for (DataFrameAnalyticsState state : dataFrameAnalyticsStateCounterMap.keySet()) {
            dataframeAnalyticsUsage.put(state.name().toLowerCase(Locale.ROOT), this.createCountUsageEntry(((Counter)dataFrameAnalyticsStateCounterMap.get(state)).get()));
        }
    }

    private void addDataFrameAnalyticsUsage(GetDataFrameAnalyticsAction.Response response, Map<String, Object> dataframeAnalyticsUsage) {
        HashMap<String, Integer> perAnalysisTypeCounterMap = new HashMap<String, Integer>();
        for (DataFrameAnalyticsConfig config : response.getResources().results()) {
            int count = perAnalysisTypeCounterMap.computeIfAbsent(config.getAnalysis().getWriteableName(), k -> 0);
            perAnalysisTypeCounterMap.put(config.getAnalysis().getWriteableName(), ++count);
        }
        dataframeAnalyticsUsage.put("analysis_counts", perAnalysisTypeCounterMap);
    }

    private void addInferenceUsage(ActionListener<Map<String, Object>> listener) {
        if (this.machineLearningExtension.isDataFrameAnalyticsEnabled() || this.machineLearningExtension.isNlpEnabled()) {
            GetTrainedModelsAction.Request getModelsRequest = new GetTrainedModelsAction.Request("*", Collections.emptyList(), Collections.emptySet());
            getModelsRequest.setPageParams(new PageParams(0, 10000));
            this.client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)getModelsRequest, ActionListener.wrap(getModelsResponse -> {
                GetTrainedModelsStatsAction.Request getStatsRequest = new GetTrainedModelsStatsAction.Request("*");
                getStatsRequest.setPageParams(new PageParams(0, 10000));
                this.client.execute((ActionType)GetTrainedModelsStatsAction.INSTANCE, (ActionRequest)getStatsRequest, ActionListener.wrap(getStatsResponse -> {
                    LinkedHashMap<String, Object> inferenceUsage = new LinkedHashMap<String, Object>();
                    this.addInferenceIngestUsage((GetTrainedModelsStatsAction.Response)getStatsResponse, (Map<String, Object>)inferenceUsage);
                    this.addTrainedModelStats((GetTrainedModelsAction.Response)getModelsResponse, (GetTrainedModelsStatsAction.Response)getStatsResponse, (Map<String, Object>)inferenceUsage);
                    this.addDeploymentStats((GetTrainedModelsStatsAction.Response)getStatsResponse, (Map<String, Object>)inferenceUsage);
                    listener.onResponse(inferenceUsage);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse(Map.of());
        }
    }

    private void addDeploymentStats(GetTrainedModelsStatsAction.Response statsResponse, Map<String, Object> inferenceUsage) {
        StatsAccumulator modelSizes = new StatsAccumulator();
        int deploymentsCount = 0;
        double avgTimeSum = 0.0;
        StatsAccumulator nodeDistribution = new StatsAccumulator();
        for (GetTrainedModelsStatsAction.Response.TrainedModelStats stats : statsResponse.getResources().results()) {
            AssignmentStats deploymentStats = stats.getDeploymentStats();
            if (deploymentStats == null) continue;
            ++deploymentsCount;
            TrainedModelSizeStats modelSizeStats = stats.getModelSizeStats();
            if (modelSizeStats != null) {
                modelSizes.add((double)modelSizeStats.getModelSizeBytes());
            }
            for (AssignmentStats.NodeStats nodeStats : deploymentStats.getNodeStats()) {
                long nodeInferenceCount = nodeStats.getInferenceCount().orElse(0L);
                avgTimeSum += nodeStats.getAvgInferenceTime().orElse(0.0) * (double)nodeInferenceCount;
                nodeDistribution.add((double)nodeInferenceCount);
            }
        }
        inferenceUsage.put("deployments", Map.of("count", deploymentsCount, "time_ms", Map.of("avg", nodeDistribution.getTotal() == 0.0 ? 0.0 : avgTimeSum / nodeDistribution.getTotal()), "model_sizes_bytes", modelSizes.asMap(), "inference_counts", nodeDistribution.asMap()));
    }

    private void addTrainedModelStats(GetTrainedModelsAction.Response modelsResponse, GetTrainedModelsStatsAction.Response statsResponse, Map<String, Object> inferenceUsage) {
        List trainedModelConfigs = modelsResponse.getResources().results();
        Map statsToModelId = statsResponse.getResources().results().stream().collect(Collectors.toMap(GetTrainedModelsStatsAction.Response.TrainedModelStats::getModelId, Function.identity()));
        HashMap<String, Map> trainedModelsUsage = new HashMap<String, Map>();
        trainedModelsUsage.put("_all", this.createCountUsageEntry(trainedModelConfigs.size()));
        StatsAccumulator estimatedOperations = new StatsAccumulator();
        StatsAccumulator estimatedMemoryUsageBytes = new StatsAccumulator();
        int createdByAnalyticsCount = 0;
        LinkedHashMap<String, Counter> inferenceConfigCounts = new LinkedHashMap<String, Counter>();
        int prepackagedCount = 0;
        for (TrainedModelConfig trainedModelConfig : trainedModelConfigs) {
            if (trainedModelConfig.getTags().contains("prepackaged")) {
                ++prepackagedCount;
                continue;
            }
            InferenceConfig inferenceConfig = trainedModelConfig.getInferenceConfig();
            if (inferenceConfig != null) {
                inferenceConfigCounts.computeIfAbsent(inferenceConfig.getName(), s -> Counter.newCounter()).addAndGet(1L);
            }
            if (trainedModelConfig.getMetadata() != null && trainedModelConfig.getMetadata().containsKey("analytics_config")) {
                ++createdByAnalyticsCount;
            }
            estimatedOperations.add((double)trainedModelConfig.getEstimatedOperations());
            if (!statsToModelId.containsKey(trainedModelConfig.getModelId())) continue;
            estimatedMemoryUsageBytes.add((double)((GetTrainedModelsStatsAction.Response.TrainedModelStats)statsToModelId.get(trainedModelConfig.getModelId())).getModelSizeStats().getModelSizeBytes());
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        counts.put("total", trainedModelConfigs.size());
        inferenceConfigCounts.forEach((configName, count) -> counts.put((String)configName, (Integer)count.get()));
        counts.put("prepackaged", prepackagedCount);
        counts.put("other", trainedModelConfigs.size() - createdByAnalyticsCount - prepackagedCount);
        trainedModelsUsage.put("count", counts);
        trainedModelsUsage.put(TrainedModelConfig.ESTIMATED_OPERATIONS.getPreferredName(), estimatedOperations.asMap());
        trainedModelsUsage.put(TrainedModelConfig.MODEL_SIZE_BYTES.getPreferredName(), estimatedMemoryUsageBytes.asMap());
        inferenceUsage.put("trained_models", trainedModelsUsage);
    }

    private void addInferenceIngestUsage(GetTrainedModelsStatsAction.Response statsResponse, Map<String, Object> inferenceUsage) {
        int pipelineCount = 0;
        StatsAccumulator docCountStats = new StatsAccumulator();
        StatsAccumulator timeStats = new StatsAccumulator();
        StatsAccumulator failureStats = new StatsAccumulator();
        for (GetTrainedModelsStatsAction.Response.TrainedModelStats modelStats : statsResponse.getResources().results()) {
            pipelineCount += modelStats.getPipelineCount();
            modelStats.getIngestStats().processorStats().values().stream().flatMap(Collection::stream).forEach(processorStat -> {
                if (processorStat.name().equals("inference")) {
                    docCountStats.add((double)processorStat.stats().ingestCount());
                    timeStats.add((double)processorStat.stats().ingestTimeInMillis());
                    failureStats.add((double)processorStat.stats().ingestFailedCount());
                }
            });
        }
        Map ingestUsage = Maps.newMapWithExpectedSize((int)6);
        ingestUsage.put("pipelines", this.createCountUsageEntry(pipelineCount));
        ingestUsage.put("num_docs_processed", this.getMinMaxSumAsLongsFromStats(docCountStats));
        ingestUsage.put("time_ms", this.getMinMaxSumAsLongsFromStats(timeStats));
        ingestUsage.put("num_failures", this.getMinMaxSumAsLongsFromStats(failureStats));
        inferenceUsage.put("ingest_processors", Collections.singletonMap("_all", ingestUsage));
    }

    private Map<String, Object> getMinMaxSumAsLongsFromStats(StatsAccumulator stats) {
        Map asMap = Maps.newMapWithExpectedSize((int)3);
        asMap.put("sum", Double.valueOf(stats.getTotal()).longValue());
        asMap.put("min", Double.valueOf(stats.getMin()).longValue());
        asMap.put("max", Double.valueOf(stats.getMax()).longValue());
        return asMap;
    }

    private static int mlNodeCount(ClusterState clusterState) {
        int mlNodeCount = 0;
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!MachineLearning.isMlNode(node)) continue;
            ++mlNodeCount;
        }
        return mlNodeCount;
    }
}

