/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.runtimefields;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.threadpool.ThreadPool;

public interface NamedGroupExtractor {
    public Map<String, ?> extract(String var1);

    public static NamedGroupExtractor dissect(String pattern) {
        return NamedGroupExtractor.dissect(pattern, null);
    }

    public static NamedGroupExtractor dissect(String pattern, String appendSeparator) {
        final DissectParser dissect = new DissectParser(pattern, appendSeparator);
        return new NamedGroupExtractor(){

            @Override
            public Map<String, ?> extract(String in) {
                return dissect.parse(in);
            }
        };
    }

    public static class GrokHelper {
        private final SetOnce<ThreadPool> threadPoolContainer = new SetOnce();
        private final Supplier<MatcherWatchdog> watchdogSupplier = () -> ((LazyInitializable)new LazyInitializable(() -> {
            ThreadPool threadPool = (ThreadPool)this.threadPoolContainer.get();
            if (threadPool == null) {
                throw new IllegalStateException("missing call to finishInitializing");
            }
            return MatcherWatchdog.newInstance((long)interval.millis(), (long)maxExecutionTime.millis(), () -> ((ThreadPool)threadPool).relativeTimeInMillis(), (delay, command) -> threadPool.schedule(command, TimeValue.timeValueMillis((long)delay), "generic"));
        })).getOrCompute();

        public GrokHelper(TimeValue interval, TimeValue maxExecutionTime) {
        }

        public void finishInitializing(ThreadPool threadPool) {
            this.threadPoolContainer.set((Object)threadPool);
        }

        public NamedGroupExtractor grok(final String pattern) {
            final MatcherWatchdog watchdog = this.watchdogSupplier.get();
            final Grok grok = AccessController.doPrivileged(new PrivilegedAction<Grok>(){

                @Override
                public Grok run() {
                    try {
                        ArrayList warnings = new ArrayList();
                        new Grok(GrokBuiltinPatterns.legacyPatterns(), pattern, watchdog, warnings::add).match("__nomatch__");
                        if (!warnings.isEmpty()) {
                            throw new IllegalArgumentException("emitted warnings: " + warnings);
                        }
                        return new Grok(GrokBuiltinPatterns.legacyPatterns(), pattern, watchdog, w -> {
                            throw new IllegalArgumentException("grok [" + pattern + "] emitted a warning: " + w);
                        });
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException("error compiling grok pattern [" + pattern + "]: " + e.getMessage(), e);
                    }
                }
            });
            return new NamedGroupExtractor(){

                @Override
                public Map<String, ?> extract(String in) {
                    return grok.captures(in);
                }
            };
        }
    }
}

