/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.scheduling;

import java.time.Duration;
import java.util.Objects;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformScheduler;

final class TransformScheduledTask {
    private static final long MIN_DELAY_MILLIS = Duration.ofSeconds(5L).toMillis();
    private static final long MAX_DELAY_MILLIS = Duration.ofHours(1L).toMillis();
    private final String transformId;
    private final TimeValue frequency;
    private final Long lastTriggeredTimeMillis;
    private final int failureCount;
    private final long nextScheduledTimeMillis;
    private final TransformScheduler.Listener listener;

    TransformScheduledTask(String transformId, TimeValue frequency, Long lastTriggeredTimeMillis, int failureCount, long nextScheduledTimeMillis, TransformScheduler.Listener listener) {
        this.transformId = Objects.requireNonNull(transformId);
        this.frequency = frequency != null ? frequency : Transform.DEFAULT_TRANSFORM_FREQUENCY;
        this.lastTriggeredTimeMillis = lastTriggeredTimeMillis;
        this.failureCount = failureCount;
        this.nextScheduledTimeMillis = nextScheduledTimeMillis;
        this.listener = Objects.requireNonNull(listener);
    }

    TransformScheduledTask(String transformId, TimeValue frequency, Long lastTriggeredTimeMillis, int failureCount, TransformScheduler.Listener listener) {
        this(transformId, frequency, lastTriggeredTimeMillis, failureCount, TransformScheduledTask.calculateNextScheduledTime(lastTriggeredTimeMillis, frequency, failureCount), listener);
    }

    static long calculateNextScheduledTime(Long lastTriggeredTimeMillis, TimeValue frequency, int failureCount) {
        long baseTime;
        long l = baseTime = lastTriggeredTimeMillis != null ? lastTriggeredTimeMillis : System.currentTimeMillis();
        if (failureCount == 0) {
            return baseTime + (frequency != null ? frequency : Transform.DEFAULT_TRANSFORM_FREQUENCY).millis();
        }
        long delayMillis = Math.min(Math.max((1L << Math.min(failureCount, 32)) * 1000L, MIN_DELAY_MILLIS), MAX_DELAY_MILLIS);
        return baseTime + delayMillis;
    }

    String getTransformId() {
        return this.transformId;
    }

    TimeValue getFrequency() {
        return this.frequency;
    }

    Long getLastTriggeredTimeMillis() {
        return this.lastTriggeredTimeMillis;
    }

    int getFailureCount() {
        return this.failureCount;
    }

    long getNextScheduledTimeMillis() {
        return this.nextScheduledTimeMillis;
    }

    TransformScheduler.Listener getListener() {
        return this.listener;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformScheduledTask that = (TransformScheduledTask)other;
        return Objects.equals(this.transformId, that.transformId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.lastTriggeredTimeMillis, that.lastTriggeredTimeMillis) && this.failureCount == that.failureCount && this.nextScheduledTimeMillis == that.nextScheduledTimeMillis && this.listener == that.listener;
    }

    public int hashCode() {
        return Objects.hash(this.transformId, this.frequency, this.lastTriggeredTimeMillis, this.failureCount, this.nextScheduledTimeMillis, System.identityHashCode(this.listener));
    }

    public String toString() {
        return "TransformScheduledTask[" + "transformId=" + this.transformId + ",frequency=" + this.frequency + ",lastTriggeredTimeMillis=" + this.lastTriggeredTimeMillis + ",failureCount=" + this.failureCount + ",nextScheduledTimeMillis=" + this.nextScheduledTimeMillis + ",listener=" + this.listener + "]";
    }
}

