/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractTransportGetResourcesAction;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportGetTransformAction
extends AbstractTransportGetResourcesAction<TransformConfig, GetTransformAction.Request, GetTransformAction.Response> {
    private static final String DANGLING_TASK_ERROR_MESSAGE_FORMAT = "Found task for transform [%s], but no configuration for it. To delete this transform use DELETE with force=true.";
    private final ClusterService clusterService;

    @Inject
    public TransportGetTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/transform/get", transportService, actionFilters, GetTransformAction.Request::new, client, xContentRegistry);
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, GetTransformAction.Request request, ActionListener<GetTransformAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        TransformNodes.warnIfNoTransformNodes(state);
        ActionListener searchTransformConfigsListener = ActionListener.wrap(r -> {
            Set transformConfigIds = r.results().stream().map(TransformConfig::getId).collect(Collectors.toSet());
            Collection<PersistentTasksCustomMetadata.PersistentTask<?>> transformTasks = TransformTask.findTransformTasks(request.getId(), state);
            List errors = transformTasks.stream().map(PersistentTasksCustomMetadata.PersistentTask::getId).filter(Predicate.not(transformConfigIds::contains)).map(transformId -> new GetTransformAction.Response.Error("dangling_task", Strings.format((String)DANGLING_TASK_ERROR_MESSAGE_FORMAT, (Object[])new Object[]{transformId}))).collect(Collectors.toList());
            listener.onResponse((Object)new GetTransformAction.Response(r.results(), r.count(), errors.isEmpty() ? null : errors));
        }, arg_0 -> listener.onFailure(arg_0));
        this.searchResources((AbstractGetResourcesRequest)request, new TaskId(this.clusterService.localNode().getId(), task.getId()), searchTransformConfigsListener);
    }

    protected ParseField getResultsField() {
        return TransformField.TRANSFORMS;
    }

    protected String[] getIndices() {
        return new String[]{".transform-internal-*", ".data-frame-internal-*"};
    }

    protected TransformConfig parse(XContentParser parser) {
        return TransformConfig.fromXContent((XContentParser)parser, null, (boolean)true);
    }

    protected ResourceNotFoundException notFoundException(String resourceId) {
        return new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{resourceId}), new Object[0]);
    }

    protected String executionOrigin() {
        return "transform";
    }

    protected String extractIdFromResource(TransformConfig transformConfig) {
        return transformConfig.getId();
    }

    protected QueryBuilder additionalQuery() {
        return QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config");
    }

    protected SearchSourceBuilder customSearchOptions(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder.sort("_index", SortOrder.DESC);
    }
}

