/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain.common.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class SystemStandardOutputLogger {
    private static final String DISABLED_SYSTEM_PROPERTY = "elastic.apm.system_output_disabled";
    private static final String DISABLED_ENV_VARIABLE = "ELASTIC_APM_SYSTEM_OUTPUT_DISABLED";
    private static final String LINE_PREFIX = "[elastic-apm-agent]";
    private static final boolean disabled = System.getSecurityManager() == null ? SystemStandardOutputLogger.isDisabledThroughConfiguration() : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return SystemStandardOutputLogger.isDisabledThroughConfiguration();
        }
    });

    public static boolean isDisabled() {
        return disabled;
    }

    private static boolean isDisabledThroughConfiguration() {
        return System.getProperty(DISABLED_SYSTEM_PROPERTY) != null || System.getenv(DISABLED_ENV_VARIABLE) != null;
    }

    public static void printStackTrace(Throwable throwable) {
        if (!disabled) {
            throwable.printStackTrace();
        }
    }

    private static void printToStdOut(String level, String message) {
        if (!disabled) {
            System.out.printf("%s %s %s%n", LINE_PREFIX, level, message);
        }
    }

    private static void printToStdErr(String level, String message) {
        if (!disabled) {
            System.err.printf("%s %s %s%n", LINE_PREFIX, level, message);
        }
    }

    public static void stdOutInfo(String message) {
        SystemStandardOutputLogger.printToStdOut("INFO", message);
    }

    public static void stdOutWarn(String message) {
        SystemStandardOutputLogger.printToStdOut("WARN", message);
    }

    public static void stdOutError(String message) {
        SystemStandardOutputLogger.printToStdOut("ERROR", message);
    }

    public static void stdErrInfo(String message) {
        SystemStandardOutputLogger.printToStdErr("INFO", message);
    }

    public static void stdErrWarn(String message) {
        SystemStandardOutputLogger.printToStdErr("WARN", message);
    }

    public static void stdErrError(String message) {
        SystemStandardOutputLogger.printToStdErr("ERROR", message);
    }
}

