/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.common.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class Counters
implements Writeable {
    private Map<String, Long> counters = new HashMap<String, Long>();

    public Counters(StreamInput in) throws IOException {
        int numCounters = in.readVInt();
        for (int i = 0; i < numCounters; ++i) {
            this.inc(in.readString(), in.readVLong());
        }
    }

    public Counters(String ... names) {
        for (String name : names) {
            this.set(name);
        }
    }

    public void set(String name) {
        this.counters.put(name, 0L);
    }

    public void inc(String name) {
        this.inc(name, 1L);
    }

    public void inc(String name, long count) {
        this.counters.merge(name, count, Long::sum);
    }

    public long get(String name) {
        return this.counters.get(name);
    }

    public long size() {
        return this.counters.size();
    }

    public boolean hasCounters() {
        return this.size() > 0L;
    }

    public Map<String, Object> toNestedMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Long> counter : this.counters.entrySet()) {
            if (counter.getKey().contains(".")) {
                String[] parts = counter.getKey().split("\\.");
                Map<String, Object> curr = map;
                for (int i = 0; i < parts.length; ++i) {
                    boolean isLast;
                    String part = parts[i];
                    boolean bl = isLast = i == parts.length - 1;
                    if (!isLast) {
                        if (!curr.containsKey(part)) {
                            curr.put(part, new HashMap());
                            curr = (Map)curr.get(part);
                            continue;
                        }
                        curr = (Map)curr.get(part);
                        continue;
                    }
                    curr.put(part, counter.getValue());
                }
                continue;
            }
            map.put(counter.getKey(), counter.getValue());
        }
        return map;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.counters.size());
        for (Map.Entry<String, Long> entry : this.counters.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVLong(entry.getValue().longValue());
        }
    }

    public static Counters merge(List<Counters> counters) {
        Counters result = new Counters(new String[0]);
        for (Counters c : counters) {
            for (Map.Entry<String, Long> entry : c.counters.entrySet()) {
                result.inc(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }
}

