/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.transforms.DestAlias;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class DestConfig
implements Writeable,
ToXContentObject {
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    public static final ParseField PIPELINE = new ParseField("pipeline", new String[0]);
    public static final ConstructingObjectParser<DestConfig, Void> STRICT_PARSER = DestConfig.createParser(false);
    public static final ConstructingObjectParser<DestConfig, Void> LENIENT_PARSER = DestConfig.createParser(true);
    private final String index;
    private final List<DestAlias> aliases;
    private final String pipeline;

    private static ConstructingObjectParser<DestConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser("data_frame_config_dest", lenient, args -> new DestConfig((String)args[0], (List)args[1], (String)args[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), INDEX);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), lenient ? DestAlias.LENIENT_PARSER : DestAlias.STRICT_PARSER, ALIASES);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), PIPELINE);
        return parser;
    }

    public DestConfig(String index, List<DestAlias> aliases, String pipeline) {
        this.index = ExceptionsHelper.requireNonNull(index, INDEX.getPreferredName());
        this.aliases = aliases;
        this.pipeline = pipeline;
    }

    public DestConfig(StreamInput in) throws IOException {
        this.index = in.readString();
        this.aliases = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0) ? in.readOptionalList(DestAlias::new) : null;
        this.pipeline = in.readOptionalString();
    }

    public String getIndex() {
        return this.index;
    }

    public List<DestAlias> getAliases() {
        return this.aliases != null ? this.aliases : List.of();
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.index.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"dest.index must not be empty", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0)) {
            out.writeOptionalCollection(this.aliases);
        }
        out.writeOptionalString(this.pipeline);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        if (this.aliases != null) {
            builder.field(ALIASES.getPreferredName(), this.aliases);
        }
        if (this.pipeline != null) {
            builder.field(PIPELINE.getPreferredName(), this.pipeline);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DestConfig that = (DestConfig)other;
        return Objects.equals(this.index, that.index) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.pipeline, that.pipeline);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.aliases, this.pipeline);
    }

    public static DestConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (DestConfig)LENIENT_PARSER.apply(parser, null) : (DestConfig)STRICT_PARSER.apply(parser, null);
    }
}

