/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class DeleteTransformAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteTransformAction INSTANCE = new DeleteTransformAction();
    public static final String NAME = "cluster:admin/transform/delete";

    private DeleteTransformAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String id;
        private final boolean force;
        private final boolean deleteDestIndex;

        public Request(String id, boolean force, boolean deleteDestIndex, TimeValue timeout) {
            super(timeout);
            this.id = ExceptionsHelper.requireNonNull(id, TransformField.ID.getPreferredName());
            this.force = force;
            this.deleteDestIndex = deleteDestIndex;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.force = in.readBoolean();
            this.deleteDestIndex = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0) ? in.readBoolean() : false;
        }

        public String getId() {
            return this.id;
        }

        public boolean isForce() {
            return this.force;
        }

        public boolean isDeleteDestIndex() {
            return this.deleteDestIndex;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.force);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0)) {
                out.writeBoolean(this.deleteDestIndex);
            }
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.timeout(), this.id, this.force, this.deleteDestIndex);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id) && this.force == other.force && this.deleteDestIndex == other.deleteDestIndex && this.timeout().equals((Object)other.timeout());
        }
    }
}

