/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.DiagnosticTrustManager;
import org.elasticsearch.common.ssl.KeyStoreUtil;
import org.elasticsearch.common.ssl.SslConfigException;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.ssl.SslDiagnostics;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.common.ssl.SslTrustConfig;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.SslSettingsLoader;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public class SSLService {
    private static final Logger logger = LogManager.getLogger(SSLService.class);
    private static final Map<String, String> ORDERED_PROTOCOL_ALGORITHM_MAP;
    private static final Setting<Boolean> DIAGNOSE_TRUST_EXCEPTIONS_SETTING;
    private final Environment env;
    private final Settings settings;
    private final boolean diagnoseTrustExceptions;
    private final Map<String, SslConfiguration> sslConfigurations;
    private final Map<SslConfiguration, SSLContextHolder> sslContexts;

    public SSLService(Environment environment) {
        this(environment, SSLService.getSSLConfigurations(environment, environment.settings()));
    }

    public SSLService(Environment environment, Map<String, SslConfiguration> sslConfigurations) {
        this.env = environment;
        this.settings = this.env.settings();
        this.diagnoseTrustExceptions = (Boolean)DIAGNOSE_TRUST_EXCEPTIONS_SETTING.get(environment.settings());
        this.sslConfigurations = sslConfigurations;
        this.sslContexts = this.loadSslConfigurations(this.sslConfigurations);
    }

    @Deprecated
    public SSLService(Settings settings, Environment environment) {
        this.env = environment;
        this.settings = this.env.settings();
        this.diagnoseTrustExceptions = (Boolean)DIAGNOSE_TRUST_EXCEPTIONS_SETTING.get(settings);
        this.sslConfigurations = SSLService.getSSLConfigurations(this.env, this.settings);
        this.sslContexts = this.loadSslConfigurations(this.sslConfigurations);
    }

    private SSLService(Environment environment, Map<String, SslConfiguration> sslConfigurations, Map<SslConfiguration, SSLContextHolder> sslContexts) {
        this.env = environment;
        this.settings = this.env.settings();
        this.diagnoseTrustExceptions = (Boolean)DIAGNOSE_TRUST_EXCEPTIONS_SETTING.get(environment.settings());
        this.sslConfigurations = sslConfigurations;
        this.sslContexts = sslContexts;
    }

    public SSLService createDynamicSSLService() {
        return new SSLService(this.env, this.sslConfigurations, this.sslContexts){

            @Override
            Map<SslConfiguration, SSLContextHolder> loadSslConfigurations(Map<String, SslConfiguration> unused) {
                return Collections.emptyMap();
            }

            @Override
            SSLContextHolder sslContextHolder(SslConfiguration sslConfiguration) {
                SSLContextHolder holder = SSLService.this.sslContexts.get(sslConfiguration);
                if (holder == null) {
                    holder = SSLService.this.createSslContext(sslConfiguration);
                }
                return holder;
            }
        };
    }

    public static void registerSettings(List<Setting<?>> settingList) {
        settingList.add(DIAGNOSE_TRUST_EXCEPTIONS_SETTING);
    }

    @Deprecated
    public SSLIOSessionStrategy sslIOSessionStrategy(Settings settingsToUse) {
        SslConfiguration config = this.sslConfiguration(settingsToUse);
        return this.sslIOSessionStrategy(config);
    }

    public SSLIOSessionStrategy sslIOSessionStrategy(SslConfiguration config) {
        SSLContext sslContext = this.sslContext(config);
        String[] ciphers = this.supportedCiphers(this.sslParameters(sslContext).getCipherSuites(), config.getCipherSuites(), false);
        String[] supportedProtocols = config.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        HostnameVerifier verifier = config.verificationMode().isHostnameVerificationEnabled() ? SSLIOSessionStrategy.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
        SSLIOSessionStrategy strategy = this.sslIOSessionStrategy(sslContext, supportedProtocols, ciphers, verifier);
        return strategy;
    }

    public static HostnameVerifier getHostnameVerifier(SslConfiguration sslConfiguration) {
        if (sslConfiguration.verificationMode().isHostnameVerificationEnabled()) {
            return new DefaultHostnameVerifier();
        }
        return NoopHostnameVerifier.INSTANCE;
    }

    SSLParameters sslParameters(SSLContext sslContext) {
        return sslContext.getSupportedSSLParameters();
    }

    SSLIOSessionStrategy sslIOSessionStrategy(SSLContext sslContext, String[] protocols, String[] ciphers, final HostnameVerifier verifier) {
        return new SSLIOSessionStrategy(sslContext, protocols, ciphers, verifier){

            protected void verifySession(HttpHost host, IOSession iosession, SSLSession session) throws SSLException {
                if (!verifier.verify(host.getHostName(), session)) {
                    Certificate[] certs = session.getPeerCertificates();
                    X509Certificate x509 = (X509Certificate)certs[0];
                    X500Principal x500Principal = x509.getSubjectX500Principal();
                    String altNames = Strings.collectionToCommaDelimitedString((Iterable)SslDiagnostics.describeValidHostnames((X509Certificate)x509));
                    throw new SSLPeerUnverifiedException(LoggerMessageFormat.format((String)"Expected SSL certificate to be valid for host [{}], but it is only valid for subject alternative names [{}] and subject [{}]", (Object[])new Object[]{host.getHostName(), altNames, x500Principal.toString()}));
                }
            }
        };
    }

    public SSLSocketFactory sslSocketFactory(SslConfiguration configuration) {
        SSLContextHolder contextHolder = this.sslContextHolder(configuration);
        SSLSocketFactory socketFactory = contextHolder.sslContext().getSocketFactory();
        SecuritySSLSocketFactory securitySSLSocketFactory = new SecuritySSLSocketFactory(() -> contextHolder.sslContext().getSocketFactory(), configuration.supportedProtocols().toArray(Strings.EMPTY_ARRAY), this.supportedCiphers(socketFactory.getSupportedCipherSuites(), configuration.getCipherSuites(), false));
        contextHolder.addReloadListener(securitySSLSocketFactory::reload);
        return securitySSLSocketFactory;
    }

    public SSLEngine createSSLEngine(SslConfiguration configuration, String host, int port) {
        SSLContext sslContext = this.sslContext(configuration);
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        String[] ciphers = this.supportedCiphers(sslEngine.getSupportedCipherSuites(), configuration.getCipherSuites(), false);
        String[] supportedProtocols = configuration.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        SSLParameters parameters = new SSLParameters(ciphers, supportedProtocols);
        if (configuration.verificationMode().isHostnameVerificationEnabled() && host != null) {
            parameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        parameters.setUseCipherSuitesOrder(true);
        configuration.clientAuth().configure(parameters);
        sslEngine.setSSLParameters(parameters);
        return sslEngine;
    }

    public static boolean isConfigurationValidForServerUsage(SslConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SslConfiguration cannot be null");
        return sslConfiguration.keyConfig().hasKeyMaterial();
    }

    public static boolean isSSLClientAuthEnabled(SslConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SslConfiguration cannot be null");
        return sslConfiguration.clientAuth().enabled();
    }

    public SSLContext sslContext(SslConfiguration configuration) {
        return this.sslContextHolder(configuration).sslContext();
    }

    public void reloadSSLContext(SslConfiguration configuration) {
        this.sslContextHolder(configuration).reload();
    }

    SSLContextHolder sslContextHolder(SslConfiguration sslConfiguration) {
        Objects.requireNonNull(sslConfiguration, "SSL Configuration cannot be null");
        SSLContextHolder holder = this.sslContexts.get(sslConfiguration);
        if (holder == null) {
            logger.info("Cannot find SSL context [{}], available contexts are [{}]", (Object)sslConfiguration, this.sslContexts.keySet());
            throw new IllegalArgumentException("did not find an SSLContext for [" + sslConfiguration.toString() + "]");
        }
        return holder;
    }

    public SslConfiguration sslConfiguration(Settings settingsToUse) {
        return SslSettingsLoader.load(settingsToUse, null, this.env);
    }

    public Set<String> getTransportProfileContextNames() {
        return this.sslConfigurations.keySet().stream().filter(k -> k.startsWith("transport.profiles.")).collect(Collectors.toUnmodifiableSet());
    }

    Collection<SslConfiguration> getLoadedSslConfigurations() {
        return Set.copyOf(this.sslContexts.keySet());
    }

    String[] supportedCiphers(String[] supportedCiphers, List<String> requestedCiphers, boolean log) {
        ArrayList<String> supportedCiphersList = new ArrayList<String>(requestedCiphers.size());
        LinkedList<String> unsupportedCiphers = new LinkedList<String>();
        for (String requestedCipher : requestedCiphers) {
            boolean found = false;
            for (String supportedCipher : supportedCiphers) {
                if (!supportedCipher.equals(requestedCipher)) continue;
                found = true;
                supportedCiphersList.add(requestedCipher);
                break;
            }
            if (found) continue;
            unsupportedCiphers.add(requestedCipher);
        }
        if (supportedCiphersList.isEmpty()) {
            throw new SslConfigException("none of the ciphers " + Arrays.toString(requestedCiphers.toArray()) + " are supported by this JVM");
        }
        if (log && !unsupportedCiphers.isEmpty()) {
            logger.error("unsupported ciphers [{}] were requested but cannot be used in this JVM, however there are supported ciphers that will be used [{}]. If you are trying to use ciphers with a key length greater than 128 bits on an Oracle JVM, you will need to install the unlimited strength JCE policy files.", unsupportedCiphers, supportedCiphersList);
        }
        return supportedCiphersList.toArray(new String[supportedCiphersList.size()]);
    }

    private SSLContextHolder createSslContext(SslConfiguration sslConfiguration) {
        if (logger.isDebugEnabled()) {
            logger.debug("using ssl settings [{}]", (Object)sslConfiguration);
        }
        X509ExtendedTrustManager trustManager = sslConfiguration.trustConfig().createTrustManager();
        X509ExtendedKeyManager keyManager = sslConfiguration.keyConfig().createKeyManager();
        return this.createSslContext(keyManager, trustManager, sslConfiguration);
    }

    private SSLContextHolder createSslContext(X509ExtendedKeyManager keyManager, X509ExtendedTrustManager trustManager, SslConfiguration sslConfiguration) {
        trustManager = this.wrapWithDiagnostics(trustManager, sslConfiguration);
        try {
            SSLContext sslContext = SSLContext.getInstance(SSLService.sslContextAlgorithm(sslConfiguration.supportedProtocols()));
            sslContext.init(new X509ExtendedKeyManager[]{keyManager}, new X509ExtendedTrustManager[]{trustManager}, null);
            this.supportedCiphers(sslContext.getSupportedSSLParameters().getCipherSuites(), sslConfiguration.getCipherSuites(), true);
            return new SSLContextHolder(sslContext, sslConfiguration);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ElasticsearchException("failed to initialize the SSLContext", (Throwable)e, new Object[0]);
        }
    }

    X509ExtendedTrustManager wrapWithDiagnostics(X509ExtendedTrustManager trustManager, SslConfiguration configuration) {
        if (this.diagnoseTrustExceptions && !(trustManager instanceof DiagnosticTrustManager)) {
            Logger diagnosticLogger = LogManager.getLogger(DiagnosticTrustManager.class);
            Supplier<String> contextName = () -> {
                List<String> names = this.sslConfigurations.entrySet().stream().filter(e -> ((SslConfiguration)e.getValue()).equals((Object)configuration)).limit(2L).map(Map.Entry::getKey).toList();
                String name = switch (names.size()) {
                    case 0 -> "(unknown)";
                    case 1 -> names.get(0);
                    default -> "(shared)";
                };
                return name + " (with trust configuration: " + configuration.trustConfig() + ")";
            };
            trustManager = new DiagnosticTrustManager(trustManager, contextName, (arg_0, arg_1) -> ((Logger)diagnosticLogger).warn(arg_0, arg_1));
        }
        return trustManager;
    }

    public static Map<String, SslConfiguration> getSSLConfigurations(Environment env) {
        return SSLService.getSSLConfigurations(env, env.settings());
    }

    private static Map<String, SslConfiguration> getSSLConfigurations(Environment env, Settings settings) {
        Map<String, Settings> sslSettingsMap = SSLService.getSSLSettingsMap(settings);
        Map sslConfigurationMap = Maps.newMapWithExpectedSize((int)sslSettingsMap.size());
        sslSettingsMap.forEach((key, sslSettings) -> {
            if (key.endsWith(".")) {
                key = key.substring(0, key.length() - 1);
            }
            try {
                sslConfigurationMap.put(key, SslSettingsLoader.load(sslSettings, null, env, SSLService.getKeyStoreFilter(key)));
            }
            catch (SslConfigException e) {
                throw new ElasticsearchSecurityException("failed to load SSL configuration [{}] - {}", (Exception)((Object)e), new Object[]{key, e.getMessage()});
            }
        });
        return Collections.unmodifiableMap(sslConfigurationMap);
    }

    private static Function<KeyStore, KeyStore> getKeyStoreFilter(String sslContext) {
        if (sslContext.equals("xpack.security.http.ssl")) {
            Function<GeneralSecurityException, RuntimeException> exceptionHandler = e -> new ElasticsearchSecurityException("Cannot process keystore for SSL configuration [" + sslContext + "] - " + e.getMessage(), (Exception)e, new Object[0]);
            Predicate<KeyStoreUtil.KeyStoreEntry> isCA = e -> e.getX509Certificate().getBasicConstraints() >= 0;
            return ks -> {
                AtomicInteger keyCount = new AtomicInteger(0);
                AtomicInteger caCount = new AtomicInteger(0);
                KeyStoreUtil.stream((KeyStore)ks, (Function)exceptionHandler).filter(e -> e.isKeyEntry()).forEach(e -> {
                    keyCount.incrementAndGet();
                    if (isCA.test((KeyStoreUtil.KeyStoreEntry)e)) {
                        caCount.incrementAndGet();
                    }
                });
                if (keyCount.get() <= 1) {
                    return ks;
                }
                if (caCount.get() > 0 && caCount.get() < keyCount.get()) {
                    return KeyStoreUtil.filter((KeyStore)ks, e -> e.isKeyEntry() && !isCA.test((KeyStoreUtil.KeyStoreEntry)e));
                }
                return ks;
            };
        }
        return null;
    }

    static Map<String, Settings> getSSLSettingsMap(Settings settings) {
        HashMap<String, Settings> sslSettingsMap = new HashMap<String, Settings>();
        sslSettingsMap.put(XPackSettings.HTTP_SSL_PREFIX, SSLService.getHttpTransportSSLSettings(settings));
        sslSettingsMap.put("xpack.http.ssl", settings.getByPrefix("xpack.http.ssl."));
        sslSettingsMap.putAll(SSLService.getRealmsSSLSettings(settings));
        sslSettingsMap.putAll(SSLService.getMonitoringExporterSettings(settings));
        sslSettingsMap.put("xpack.notification.email.ssl.", settings.getByPrefix("xpack.notification.email.ssl."));
        sslSettingsMap.put(XPackSettings.TRANSPORT_SSL_PREFIX, settings.getByPrefix(XPackSettings.TRANSPORT_SSL_PREFIX));
        sslSettingsMap.putAll(SSLService.getTransportProfileSSLSettings(settings));
        if (((Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(settings)).booleanValue()) {
            sslSettingsMap.put(XPackSettings.REMOTE_CLUSTER_SERVER_SSL_PREFIX, SSLService.getRemoteClusterServerSslSettings(settings));
        }
        sslSettingsMap.put(XPackSettings.REMOTE_CLUSTER_CLIENT_SSL_PREFIX, settings.getByPrefix(XPackSettings.REMOTE_CLUSTER_CLIENT_SSL_PREFIX));
        return Collections.unmodifiableMap(sslSettingsMap);
    }

    Map<SslConfiguration, SSLContextHolder> loadSslConfigurations(Map<String, SslConfiguration> sslConfigurationMap) {
        Map sslContextHolders = Maps.newMapWithExpectedSize((int)sslConfigurationMap.size());
        sslConfigurationMap.forEach((key, sslConfiguration) -> {
            try {
                sslContextHolders.computeIfAbsent(sslConfiguration, this::createSslContext);
            }
            catch (SslConfigException e) {
                throw new ElasticsearchSecurityException("failed to load SSL configuration [{}] - {}", (Exception)((Object)e), new Object[]{key, e.getMessage()});
            }
            catch (Exception e) {
                throw new ElasticsearchSecurityException("failed to load SSL configuration [{}] - {}", e, new Object[]{key, e});
            }
        });
        for (String context : List.of("xpack.security.transport.ssl", "xpack.security.http.ssl")) {
            this.validateServerConfiguration(context);
        }
        this.maybeValidateRemoteClusterServerConfiguration();
        return Collections.unmodifiableMap(sslContextHolders);
    }

    private void validateServerConfiguration(String prefix) {
        List<String> sslSettingNames;
        assert (prefix.endsWith(".ssl"));
        SslConfiguration configuration = this.getSSLConfiguration(prefix);
        String enabledSetting = prefix + ".enabled";
        if (this.settings.getAsBoolean(enabledSetting, Boolean.valueOf(false)).booleanValue()) {
            SSLConfigurationSettings configurationSettings = SSLConfigurationSettings.withPrefix(prefix + ".", true);
            if (!SSLService.isConfigurationValidForServerUsage(configuration)) {
                SSLService.throwExceptionForMissingKeyMaterial(prefix, configurationSettings);
            }
        } else if (!this.settings.hasValue(enabledSetting) && !(sslSettingNames = this.settings.keySet().stream().filter(s -> s.startsWith(prefix)).sorted().toList()).isEmpty()) {
            throw new ElasticsearchSecurityException("invalid configuration for " + prefix + " - [" + enabledSetting + "] is not set, but the following settings have been configured in elasticsearch.yml : [" + Strings.collectionToCommaDelimitedString(sslSettingNames) + "]", new Object[0]);
        }
    }

    private void maybeValidateRemoteClusterServerConfiguration() {
        if (!((Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(this.settings)).booleanValue()) {
            return;
        }
        SslConfiguration sslConfiguration = this.getSSLConfiguration(XPackSettings.REMOTE_CLUSTER_SERVER_SSL_PREFIX);
        if (((Boolean)XPackSettings.REMOTE_CLUSTER_SERVER_SSL_ENABLED.get(this.settings)).booleanValue() && !SSLService.isConfigurationValidForServerUsage(sslConfiguration)) {
            SSLConfigurationSettings configurationSettings = SSLConfigurationSettings.withPrefix(XPackSettings.REMOTE_CLUSTER_SERVER_SSL_PREFIX, false);
            SSLService.throwExceptionForMissingKeyMaterial(XPackSettings.REMOTE_CLUSTER_SERVER_SSL_PREFIX, configurationSettings);
        }
    }

    private static void throwExceptionForMissingKeyMaterial(String prefix, SSLConfigurationSettings configurationSettings) {
        throw new ElasticsearchSecurityException("invalid SSL configuration for " + (prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix) + " - server ssl configuration requires a key and certificate, but these have not been configured; you must set either [" + configurationSettings.x509KeyPair.keystorePath.getKey() + "], or both [" + configurationSettings.x509KeyPair.keyPath.getKey() + "] and [" + configurationSettings.x509KeyPair.certificatePath.getKey() + "]", new Object[0]);
    }

    public Collection<CertificateInfo> getLoadedCertificates() throws GeneralSecurityException, IOException {
        return (Collection)this.getLoadedSslConfigurations().stream().map(SslConfiguration::getConfiguredCertificates).flatMap(Collection::stream).map(cert -> new CertificateInfo(cert.path(), cert.format(), cert.alias(), cert.hasPrivateKey(), cert.certificate())).collect(Sets.toUnmodifiableSortedSet());
    }

    static void invalidateSessions(SSLSessionContext sslSessionContext) {
        Enumeration<byte[]> sessionIds = sslSessionContext.getIds();
        while (sessionIds.hasMoreElements()) {
            byte[] sessionId = sessionIds.nextElement();
            SSLSession session = sslSessionContext.getSession(sessionId);
            if (session == null) continue;
            session.invalidate();
        }
    }

    private static Map<String, Settings> getRealmsSSLSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        String prefix = "xpack.security.authc.realms.";
        Map settingsByRealmType = settings.getGroups("xpack.security.authc.realms.");
        settingsByRealmType.forEach((realmType, typeSettings) -> {
            Optional<String> nonDottedSetting = typeSettings.keySet().stream().filter(k -> k.indexOf(46) == -1).findAny();
            if (nonDottedSetting.isPresent()) {
                logger.warn("Skipping any SSL configuration from realm [{}{}] because the key [{}] is not in the correct format", (Object)"xpack.security.authc.realms.", realmType, (Object)nonDottedSetting.get());
            } else {
                typeSettings.getAsGroups().forEach((realmName, realmSettings) -> {
                    Settings realmSSLSettings = realmSettings.getByPrefix("ssl.");
                    sslSettings.put("xpack.security.authc.realms." + realmType + "." + realmName + ".ssl", realmSSLSettings);
                });
            }
        });
        return sslSettings;
    }

    private static Map<String, Settings> getTransportProfileSSLSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        Map profiles = settings.getGroups("transport.profiles.", true);
        for (Map.Entry entry : profiles.entrySet()) {
            Settings profileSettings = ((Settings)entry.getValue()).getByPrefix("xpack.security.ssl.");
            sslSettings.put("transport.profiles." + (String)entry.getKey() + ".xpack.security.ssl", profileSettings);
        }
        return sslSettings;
    }

    private static Settings getHttpTransportSSLSettings(Settings settings) {
        Settings httpSSLSettings = settings.getByPrefix(XPackSettings.HTTP_SSL_PREFIX);
        if (httpSSLSettings.isEmpty()) {
            return httpSSLSettings;
        }
        Settings.Builder builder = Settings.builder().put(httpSSLSettings);
        if (builder.get("client_authentication") == null) {
            builder.put("client_authentication", (Enum)XPackSettings.HTTP_CLIENT_AUTH_DEFAULT);
        }
        return builder.build();
    }

    private static Settings getRemoteClusterServerSslSettings(Settings settings) {
        Settings remoteClusterSslSettings = settings.getByPrefix(XPackSettings.REMOTE_CLUSTER_SERVER_SSL_PREFIX);
        Settings.Builder builder = Settings.builder().put(remoteClusterSslSettings);
        if (builder.get("client_authentication") == null) {
            builder.put("client_authentication", (Enum)XPackSettings.REMOTE_CLUSTER_CLIENT_AUTH_DEFAULT);
        }
        return builder.build();
    }

    public SslConfiguration getHttpTransportSSLConfiguration() {
        return this.getSSLConfiguration(XPackSettings.HTTP_SSL_PREFIX);
    }

    public SslConfiguration getTransportSSLConfiguration() {
        return this.getSSLConfiguration(XPackSettings.TRANSPORT_SSL_PREFIX);
    }

    private static Map<String, Settings> getMonitoringExporterSettings(Settings settings) {
        HashMap<String, Settings> sslSettings = new HashMap<String, Settings>();
        Map exportersSettings = settings.getGroups("xpack.monitoring.exporters.");
        for (Map.Entry entry : exportersSettings.entrySet()) {
            Settings exporterSSLSettings = ((Settings)entry.getValue()).getByPrefix("ssl.");
            sslSettings.put("xpack.monitoring.exporters." + (String)entry.getKey() + ".ssl", exporterSSLSettings);
        }
        return sslSettings;
    }

    public SslConfiguration getSSLConfiguration(String contextName) {
        SslConfiguration configuration;
        if (contextName.endsWith(".")) {
            contextName = contextName.substring(0, contextName.length() - 1);
        }
        if ((configuration = this.sslConfigurations.get(contextName)) == null) {
            logger.warn("Cannot find SSL configuration for context {}. Known contexts are: {}", (Object)contextName, (Object)Strings.collectionToCommaDelimitedString(this.sslConfigurations.keySet()));
        } else {
            logger.debug("SSL configuration [{}] is [{}]", (Object)contextName, (Object)configuration);
        }
        return configuration;
    }

    private static String sslContextAlgorithm(List<String> supportedProtocols) {
        if (supportedProtocols.isEmpty()) {
            throw new IllegalArgumentException("no SSL/TLS protocols have been configured");
        }
        for (Map.Entry<String, String> entry : ORDERED_PROTOCOL_ALGORITHM_MAP.entrySet()) {
            if (!supportedProtocols.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("no supported SSL/TLS protocol was found in the configured supported protocols: " + supportedProtocols);
    }

    static {
        LinkedHashMap<String, String> protocolAlgorithmMap = new LinkedHashMap<String, String>();
        if (XPackSettings.DEFAULT_SUPPORTED_PROTOCOLS.contains("TLSv1.3")) {
            protocolAlgorithmMap.put("TLSv1.3", "TLSv1.3");
        }
        protocolAlgorithmMap.put("TLSv1.2", "TLSv1.2");
        protocolAlgorithmMap.put("TLSv1.1", "TLSv1.1");
        protocolAlgorithmMap.put("TLSv1", "TLSv1");
        protocolAlgorithmMap.put("SSLv3", "SSLv3");
        protocolAlgorithmMap.put("SSLv2", "SSL");
        protocolAlgorithmMap.put("SSLv2Hello", "SSL");
        ORDERED_PROTOCOL_ALGORITHM_MAP = Collections.unmodifiableMap(protocolAlgorithmMap);
        DIAGNOSE_TRUST_EXCEPTIONS_SETTING = Setting.boolSetting((String)"xpack.security.ssl.diagnose.trust", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }

    final class SSLContextHolder {
        private volatile SSLContext context;
        private final SslKeyConfig keyConfig;
        private final SslTrustConfig trustConfig;
        private final SslConfiguration sslConfiguration;
        private final List<Runnable> reloadListeners;

        SSLContextHolder(SSLContext context, SslConfiguration sslConfiguration) {
            this.context = context;
            this.sslConfiguration = sslConfiguration;
            this.keyConfig = sslConfiguration.keyConfig();
            this.trustConfig = sslConfiguration.trustConfig();
            this.reloadListeners = new ArrayList<Runnable>();
        }

        SSLContext sslContext() {
            return this.context;
        }

        synchronized void reload() {
            SSLService.invalidateSessions(this.context.getClientSessionContext());
            SSLService.invalidateSessions(this.context.getServerSessionContext());
            this.reloadSslContext();
            this.reloadListeners.forEach(Runnable::run);
        }

        private void reloadSslContext() {
            try {
                X509ExtendedKeyManager loadedKeyManager = this.keyConfig.createKeyManager();
                X509ExtendedTrustManager loadedTrustManager = this.trustConfig.createTrustManager();
                loadedTrustManager = SSLService.this.wrapWithDiagnostics(loadedTrustManager, this.sslConfiguration);
                SSLContext loadedSslContext = SSLContext.getInstance(SSLService.sslContextAlgorithm(this.sslConfiguration.supportedProtocols()));
                loadedSslContext.init(new X509ExtendedKeyManager[]{loadedKeyManager}, new X509ExtendedTrustManager[]{loadedTrustManager}, null);
                SSLService.this.supportedCiphers(loadedSslContext.getSupportedSSLParameters().getCipherSuites(), this.sslConfiguration.getCipherSuites(), false);
                this.context = loadedSslContext;
            }
            catch (GeneralSecurityException e) {
                throw new ElasticsearchException("failed to initialize the SSLContext", (Throwable)e, new Object[0]);
            }
        }

        public void addReloadListener(Runnable listener) {
            this.reloadListeners.add(listener);
        }
    }

    private static class SecuritySSLSocketFactory
    extends SSLSocketFactory {
        private final Supplier<SSLSocketFactory> delegateSupplier;
        private final String[] supportedProtocols;
        private final String[] ciphers;
        private volatile SSLSocketFactory delegate;

        SecuritySSLSocketFactory(Supplier<SSLSocketFactory> delegateSupplier, String[] supportedProtocols, String[] ciphers) {
            this.delegateSupplier = delegateSupplier;
            this.delegate = this.delegateSupplier.get();
            this.supportedProtocols = supportedProtocols;
            this.ciphers = ciphers;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.ciphers;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)this.delegate::createSocket));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(socket, host, port, autoClose)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port, localHost, localPort)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(host, port)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            SSLSocket sslSocket = SecuritySSLSocketFactory.createWithPermissions((CheckedSupplier<Socket, IOException>)((CheckedSupplier)() -> this.delegate.createSocket(address, port, localAddress, localPort)));
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        public void reload() {
            SSLSocketFactory newDelegate;
            this.delegate = newDelegate = this.delegateSupplier.get();
        }

        private void configureSSLSocket(SSLSocket socket) {
            SSLParameters parameters = new SSLParameters(this.ciphers, this.supportedProtocols);
            parameters.setUseCipherSuitesOrder(true);
            socket.setSSLParameters(parameters);
        }

        private static SSLSocket createWithPermissions(CheckedSupplier<Socket, IOException> supplier) throws IOException {
            return (SSLSocket)SocketAccess.doPrivileged(supplier);
        }
    }
}

