/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;

public class InternalUsers {
    public static final InternalUser ASYNC_SEARCH_USER = new InternalUser("_async_search", new RoleDescriptor("_async_search", new String[]{"cancel_task"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".async-search*").privileges("all").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null));
    public static final InternalUser SECURITY_PROFILE_USER = new InternalUser("_security_profile", new RoleDescriptor("_security_profile", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".security-profile", "/\\.security-profile-[0-9].*/").privileges("all").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser STORAGE_USER = new InternalUser("_storage", new RoleDescriptor("_storage", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("indices:admin/refresh*").allowRestrictedIndices(true).build()}, new String[0], MetadataUtils.DEFAULT_RESERVED_METADATA));
    public static final InternalUser XPACK_USER = new InternalUser("_xpack", new RoleDescriptor("_xpack", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("/@&~(\\.security.*)&~(\\.async-search.*)/").privileges("all").allowRestrictedIndices(true).build()}, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA));
    public static final InternalUser XPACK_SECURITY_USER = new InternalUser("_xpack_security", new RoleDescriptor("_xpack_security", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").allowRestrictedIndices(true).build()}, null, null, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser DATA_STREAM_LIFECYCLE_USER = new InternalUser("_data_stream_lifecycle", new RoleDescriptor("_data_stream_lifecycle", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("delete_index", "indices:admin/rollover", "indices:admin/forcemerge*", "indices:monitor/stats*", "indices:admin/settings/update").allowRestrictedIndices(false).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".fleet-actions-results", ".fleet-fileds*").privileges("delete_index", "indices:admin/rollover", "indices:admin/forcemerge*", "indices:monitor/stats*", "indices:admin/settings/update").allowRestrictedIndices(true).build()}, null, null, new String[0], MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final InternalUser SYNONYMS_USER = new InternalUser("_synonyms", new RoleDescriptor("_synonyms", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".synonyms*").privileges("all").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("indices:admin/reload_analyzers").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of()));
    public static final SystemUser SYSTEM_USER = SystemUser.INSTANCE;
    private static final Map<String, InternalUser> INTERNAL_USERS = Stream.of(SYSTEM_USER, XPACK_USER, XPACK_SECURITY_USER, SECURITY_PROFILE_USER, ASYNC_SEARCH_USER, STORAGE_USER, DATA_STREAM_LIFECYCLE_USER, SYNONYMS_USER).collect(Collectors.toUnmodifiableMap(User::principal, Function.identity()));

    public static Collection<InternalUser> get() {
        return Collections.unmodifiableCollection(INTERNAL_USERS.values());
    }

    public static InternalUser getUser(String username) {
        InternalUser instance = INTERNAL_USERS.get(username);
        if (instance == null) {
            throw new IllegalStateException("user [" + username + "] is not internal");
        }
        return instance;
    }
}

