/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.profile;

import java.io.IOException;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.profile.Profile;

public class SuggestProfilesResponse
extends ActionResponse
implements ToXContentObject {
    private final ProfileHit[] profileHits;
    private final long tookInMillis;
    private final TotalHits totalHits;

    public SuggestProfilesResponse(ProfileHit[] profileHits, long tookInMillis, TotalHits totalHits) {
        this.profileHits = profileHits;
        this.tookInMillis = tookInMillis;
        this.totalHits = totalHits;
    }

    public SuggestProfilesResponse(StreamInput in) throws IOException {
        super(in);
        this.profileHits = (ProfileHit[])in.readArray(ProfileHit::new, ProfileHit[]::new);
        this.tookInMillis = in.readVLong();
        this.totalHits = Lucene.readTotalHits((StreamInput)in);
    }

    public ProfileHit[] getProfileHits() {
        return this.profileHits;
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((Writeable[])this.profileHits);
        out.writeVLong(this.tookInMillis);
        Lucene.writeTotalHits((StreamOutput)out, (TotalHits)this.totalHits);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("took", this.tookInMillis);
        builder.startObject("total");
        builder.field("value", this.totalHits.value);
        builder.field("relation", this.totalHits.relation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte");
        builder.endObject();
        builder.startArray("profiles");
        for (ProfileHit profileHit : this.profileHits) {
            profileHit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public record ProfileHit(Profile profile, float score) implements Writeable,
    ToXContentObject
    {
        public ProfileHit(StreamInput in) throws IOException {
            this(new Profile(in), in.readFloat());
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.profile.writeTo(out);
            out.writeFloat(this.score);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("uid", this.profile.uid());
            this.profile.user().toXContent(builder, params);
            builder.field("labels", this.profile.labels());
            builder.field("data", this.profile.applicationData());
            builder.endObject();
            return builder;
        }
    }
}

