/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class SuggestProfilesRequest
extends ActionRequest {
    private final Set<String> dataKeys;
    private final String name;
    private final int size;
    @Nullable
    private final Hint hint;

    public SuggestProfilesRequest(Set<String> dataKeys, String name, int size, Hint hint) {
        this.dataKeys = Objects.requireNonNull(dataKeys, "data parameter must not be null");
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.size = size;
        this.hint = hint;
    }

    public SuggestProfilesRequest(StreamInput in) throws IOException {
        super(in);
        this.dataKeys = in.readSet(StreamInput::readString);
        this.name = in.readOptionalString();
        this.size = in.readVInt();
        this.hint = (Hint)in.readOptionalWriteable(Hint::new);
    }

    public Set<String> getDataKeys() {
        return this.dataKeys;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public Hint getHint() {
        return this.hint;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.dataKeys);
        out.writeOptionalString(this.name);
        out.writeVInt(this.size);
        out.writeOptionalWriteable((Writeable)this.hint);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.size < 0) {
            validationException = ValidateActions.addValidationError((String)("[size] parameter cannot be negative but was [" + this.size + "]"), validationException);
        }
        if (this.hint != null) {
            validationException = this.hint.validate(validationException);
        }
        return validationException;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    public String getDescription() {
        return "SuggestProfiles{name='" + this.name + "', hint=" + this.hint + "}";
    }

    public static class Hint
    implements Writeable {
        @Nullable
        private final List<String> uids;
        @Nullable
        private final Map<String, List<String>> labels;

        public Hint(List<String> uids, Map<String, Object> labelsInput) {
            List<String> list = this.uids = uids == null ? null : List.copyOf(uids);
            if (labelsInput != null) {
                HashMap labels = new HashMap();
                for (Map.Entry<String, Object> entry : labelsInput.entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        labels.put(entry.getKey(), List.of((String)value));
                        continue;
                    }
                    if (value instanceof List) {
                        List listValue = (List)value;
                        ArrayList<String> values = new ArrayList<String>();
                        for (Object v : listValue) {
                            if (v instanceof String) {
                                String stringValue = (String)v;
                                values.add(stringValue);
                                continue;
                            }
                            throw new ElasticsearchParseException("[labels] hint supports either string value or list of strings", new Object[0]);
                        }
                        labels.put(entry.getKey(), List.copyOf(values));
                        continue;
                    }
                    throw new ElasticsearchParseException("[labels] hint supports either string or list of strings as its value", new Object[0]);
                }
                this.labels = Map.copyOf(labels);
            } else {
                this.labels = null;
            }
        }

        public Hint(StreamInput in) throws IOException {
            this.uids = in.readStringList();
            this.labels = in.readMapOfLists(StreamInput::readString);
        }

        public List<String> getUids() {
            return this.uids;
        }

        public Tuple<String, List<String>> getSingleLabel() {
            if (this.labels == null) {
                return null;
            }
            assert (this.labels.size() == 1) : "labels hint support exactly one key";
            String labelKey = this.labels.keySet().iterator().next();
            List<String> labelValues = this.labels.get(labelKey);
            assert (!labelValues.isEmpty()) : "label values cannot be empty";
            return new Tuple((Object)labelKey, labelValues);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.uids);
            out.writeMapOfLists(this.labels, StreamOutput::writeString, StreamOutput::writeString);
        }

        private ActionRequestValidationException validate(ActionRequestValidationException validationException) {
            if (this.uids == null && this.labels == null) {
                return ValidateActions.addValidationError((String)"[hint] parameter cannot be empty", (ActionRequestValidationException)validationException);
            }
            if (this.uids != null && this.uids.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)"[uids] hint cannot be empty", (ActionRequestValidationException)validationException);
            }
            if (this.labels != null) {
                List<String> values;
                if (this.labels.size() != 1) {
                    return ValidateActions.addValidationError((String)("[labels] hint supports a single key, got [" + Strings.collectionToCommaDelimitedString(this.labels.keySet()) + "]"), (ActionRequestValidationException)validationException);
                }
                String key = this.labels.keySet().iterator().next();
                if (key.contains("*")) {
                    validationException = ValidateActions.addValidationError((String)"[labels] hint key cannot contain wildcard", (ActionRequestValidationException)validationException);
                }
                if ((values = this.labels.get(key)).isEmpty()) {
                    validationException = ValidateActions.addValidationError((String)"[labels] hint value cannot be empty", (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public String toString() {
            return "Hint{uids=" + this.uids + ", labels=" + this.labels + "}";
        }
    }
}

