/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.action.GrantRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;

public final class GrantApiKeyRequest
extends GrantRequest {
    private CreateApiKeyRequest apiKey;

    public GrantApiKeyRequest() {
        this.apiKey = new CreateApiKeyRequest();
    }

    public GrantApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.apiKey = new CreateApiKeyRequest(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.apiKey.writeTo(out);
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.apiKey.getRefreshPolicy();
    }

    public void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.apiKey.setRefreshPolicy(refreshPolicy);
    }

    public CreateApiKeyRequest getApiKeyRequest() {
        return this.apiKey;
    }

    public void setApiKeyRequest(CreateApiKeyRequest apiKeyRequest) {
        this.apiKey = Objects.requireNonNull(apiKeyRequest, "Cannot set a null api_key");
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = this.apiKey.validate();
        return this.grant.validate(validationException);
    }
}

