/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextExpansionConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TextExpansionConfigUpdate
extends NlpConfigUpdate {
    public static final String NAME = "text_expansion";
    public static final TextExpansionConfigUpdate EMPTY_UPDATE = new TextExpansionConfigUpdate(null, null);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = TextExpansionConfigUpdate.createParser(false);
    private final String resultsField;

    public static TextExpansionConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        String resultsField = (String)options.remove(NlpConfig.RESULTS_FIELD.getPreferredName());
        TokenizationUpdate tokenizationUpdate = NlpConfigUpdate.tokenizationFromMap(options);
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", options.keySet());
        }
        return new TextExpansionConfigUpdate(resultsField, tokenizationUpdate);
    }

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME, lenient, Builder::new);
        parser.declareString(Builder::setResultsField, NlpConfig.RESULTS_FIELD);
        parser.declareNamedObject(Builder::setTokenizationUpdate, (p, c, n) -> (TokenizationUpdate)p.namedObject(TokenizationUpdate.class, n, (Object)lenient), NlpConfig.TOKENIZATION);
        return parser;
    }

    public static TextExpansionConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public TextExpansionConfigUpdate(String resultsField, TokenizationUpdate tokenizationUpdate) {
        super(tokenizationUpdate);
        this.resultsField = resultsField;
    }

    public TextExpansionConfigUpdate(StreamInput in) throws IOException {
        super(in);
        this.resultsField = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.resultsField != null) {
            builder.field(NlpConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public InferenceConfig apply(InferenceConfig originalConfig) {
        if (!(originalConfig instanceof TextExpansionConfig)) {
            throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
        }
        TextExpansionConfig textExpansionConfig = (TextExpansionConfig)originalConfig;
        if (this.isNoop(textExpansionConfig)) {
            return textExpansionConfig;
        }
        return new TextExpansionConfig(textExpansionConfig.getVocabularyConfig(), this.tokenizationUpdate == null ? textExpansionConfig.getTokenization() : this.tokenizationUpdate.apply(textExpansionConfig.getTokenization()), Optional.ofNullable(this.resultsField).orElse(textExpansionConfig.getResultsField()));
    }

    boolean isNoop(TextExpansionConfig originalConfig) {
        return (this.resultsField == null || this.resultsField.equals(originalConfig.getResultsField())) && super.isNoop();
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return config instanceof TextExpansionConfig;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setResultsField(this.resultsField).setTokenizationUpdate(this.tokenizationUpdate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextExpansionConfigUpdate that = (TextExpansionConfigUpdate)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.tokenizationUpdate, that.tokenizationUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.resultsField, this.tokenizationUpdate);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.V_8_7_0;
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, TextExpansionConfigUpdate> {
        private String resultsField;
        private TokenizationUpdate tokenizationUpdate;

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setTokenizationUpdate(TokenizationUpdate tokenizationUpdate) {
            this.tokenizationUpdate = tokenizationUpdate;
            return this;
        }

        @Override
        public TextExpansionConfigUpdate build() {
            return new TextExpansionConfigUpdate(this.resultsField, this.tokenizationUpdate);
        }
    }
}

