/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class FillMaskConfig
implements NlpConfig {
    public static final String NAME = "fill_mask";
    public static final String MASK_TOKEN = "mask_token";
    public static final int DEFAULT_NUM_RESULTS = 5;
    private static final ParseField MASK_TOKEN_FIELD = new ParseField("mask_token", new String[0]);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = FillMaskConfig.createParser(false);
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = FillMaskConfig.createParser(true);
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final int numTopClasses;
    private final String resultsField;

    public static FillMaskConfig fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public static FillMaskConfig fromXContentLenient(XContentParser parser) {
        return ((Builder)LENIENT_PARSER.apply(parser, null)).build();
    }

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(NAME, ignoreUnknownFields, Builder::new);
        parser.declareObject(Builder::setVocabularyConfig, (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(Builder::setTokenization, (p, c, n) -> (Tokenization)p.namedObject(Tokenization.class, n, (Object)ignoreUnknownFields), TOKENIZATION);
        parser.declareInt(Builder::setNumTopClasses, NUM_TOP_CLASSES);
        parser.declareString(Builder::setResultsField, RESULTS_FIELD);
        parser.declareString(Builder::setMaskToken, MASK_TOKEN_FIELD);
        return parser;
    }

    public FillMaskConfig(@Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, @Nullable Integer numTopClasses, @Nullable String resultsField) {
        this.vocabularyConfig = Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore()));
        this.tokenization = tokenization == null ? Tokenization.createDefault() : tokenization;
        this.numTopClasses = numTopClasses == null ? 5 : numTopClasses;
        this.resultsField = resultsField;
        if (this.tokenization.span != -1) {
            throw ExceptionsHelper.badRequestException("[{}] does not support windowing long text sequences; configured span [{}]", NAME, this.tokenization.span);
        }
    }

    public FillMaskConfig(StreamInput in) throws IOException {
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = (Tokenization)in.readNamedWriteable(Tokenization.class);
        this.numTopClasses = in.readInt();
        this.resultsField = in.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), (ToXContent)this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        builder.field(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (!params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(MASK_TOKEN_FIELD.getPreferredName(), this.tokenization.getMaskToken());
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.tokenization);
        out.writeInt(this.numTopClasses);
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.V_8_0_0;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersion.V_8_0_0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillMaskConfig that = (FillMaskConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.resultsField, that.resultsField) && this.numTopClasses == that.numTopClasses;
    }

    public int hashCode() {
        return Objects.hash(this.vocabularyConfig, this.tokenization, this.numTopClasses, this.resultsField);
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    public int getNumTopClasses() {
        return this.numTopClasses;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }

    public static class Builder {
        private VocabularyConfig vocabularyConfig;
        private Tokenization tokenization;
        private Integer numTopClasses;
        private String resultsField;
        private String maskToken;

        Builder() {
        }

        Builder(FillMaskConfig config) {
            this.vocabularyConfig = config.vocabularyConfig;
            this.tokenization = config.tokenization;
            this.numTopClasses = config.numTopClasses;
            this.resultsField = config.resultsField;
        }

        public Builder setVocabularyConfig(VocabularyConfig vocabularyConfig) {
            this.vocabularyConfig = vocabularyConfig;
            return this;
        }

        public Builder setTokenization(Tokenization tokenization) {
            this.tokenization = tokenization;
            return this;
        }

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setMaskToken(String maskToken) {
            this.maskToken = maskToken;
            return this;
        }

        public FillMaskConfig build() throws IllegalArgumentException {
            if (this.tokenization == null) {
                this.tokenization = Tokenization.createDefault();
            }
            this.validateMaskToken(this.tokenization.getMaskToken());
            return new FillMaskConfig(this.vocabularyConfig, this.tokenization, this.numTopClasses, this.resultsField);
        }

        private void validateMaskToken(String tokenizationMaskToken) throws IllegalArgumentException {
            if (this.maskToken != null && !this.maskToken.equals(tokenizationMaskToken)) {
                throw new IllegalArgumentException(Strings.format((String)"Mask token requested was [%s] but must be [%s] for this model", (Object[])new Object[]{this.maskToken, tokenizationMaskToken}));
            }
        }
    }
}

