/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.NlpInferenceResults;

public class TextExpansionResults
extends NlpInferenceResults {
    public static final String NAME = "text_expansion_result";
    private final String resultsField;
    private final List<WeightedToken> weightedTokens;

    public TextExpansionResults(String resultField, List<WeightedToken> weightedTokens, boolean isTruncated) {
        super(isTruncated);
        this.resultsField = resultField;
        this.weightedTokens = weightedTokens;
    }

    public TextExpansionResults(StreamInput in) throws IOException {
        super(in);
        this.resultsField = in.readString();
        this.weightedTokens = in.readList(WeightedToken::new);
    }

    public List<WeightedToken> getWeightedTokens() {
        return this.weightedTokens;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public Object predictedValue() {
        throw new UnsupportedOperationException("[text_expansion_result] does not support a single predicted value");
    }

    @Override
    void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.resultsField);
        for (WeightedToken weightedToken : this.weightedTokens) {
            weightedToken.toXContent(builder, params);
        }
        builder.endObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextExpansionResults that = (TextExpansionResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.weightedTokens, that.weightedTokens);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, this.weightedTokens);
    }

    @Override
    void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.resultsField);
        out.writeList(this.weightedTokens);
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.weightedTokens.stream().collect(Collectors.toMap(WeightedToken::token, WeightedToken::weight)));
    }

    public record WeightedToken(String token, float weight) implements Writeable,
    ToXContentFragment
    {
        public WeightedToken(StreamInput in) throws IOException {
            this(in.readString(), in.readFloat());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.token);
            out.writeFloat(this.weight);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.token, this.weight);
            return builder;
        }

        public Map<String, Object> asMap() {
            return Map.of(this.token, Float.valueOf(this.weight));
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

