/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;

abstract class NlpInferenceResults
implements InferenceResults {
    protected final boolean isTruncated;

    NlpInferenceResults(boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    NlpInferenceResults(StreamInput in) throws IOException {
        this.isTruncated = in.readBoolean();
    }

    abstract void doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    abstract void doWriteTo(StreamOutput var1) throws IOException;

    abstract void addMapFields(Map<String, Object> var1);

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isTruncated);
        this.doWriteTo(out);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.doXContentBody(builder, params);
        if (this.isTruncated) {
            builder.field("is_truncated", this.isTruncated);
        }
        return builder;
    }

    @Override
    public final Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.addMapFields(map);
        if (this.isTruncated) {
            map.put("is_truncated", this.isTruncated);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NlpInferenceResults that = (NlpInferenceResults)o;
        return this.isTruncated == that.isTruncated;
    }

    public int hashCode() {
        return Objects.hash(this.isTruncated);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

