/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.metrics.Percentiles;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.common.AbstractAucRoc;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.outlierdetection.OutlierDetection;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class AucRoc
extends AbstractAucRoc {
    public static final ParseField INCLUDE_CURVE = new ParseField("include_curve", new String[0]);
    public static final ConstructingObjectParser<AucRoc, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new AucRoc((Boolean)a[0]));
    private static final String TRUE_AGG_NAME;
    private static final String NON_TRUE_AGG_NAME;
    private static final String PERCENTILES_AGG_NAME = "percentiles";
    private final boolean includeCurve;
    private final SetOnce<EvaluationFields> fields = new SetOnce();
    private final SetOnce<EvaluationMetricResult> result = new SetOnce();

    public static AucRoc fromXContent(XContentParser parser) {
        return (AucRoc)PARSER.apply(parser, null);
    }

    public AucRoc(Boolean includeCurve) {
        this.includeCurve = includeCurve == null ? false : includeCurve;
    }

    public AucRoc(StreamInput in) throws IOException {
        this.includeCurve = in.readBoolean();
    }

    public String getWriteableName() {
        return MlEvaluationNamedXContentProvider.registeredMetricName(OutlierDetection.NAME, NAME);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.includeCurve);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INCLUDE_CURVE.getPreferredName(), this.includeCurve);
        builder.endObject();
        return builder;
    }

    @Override
    public Set<String> getRequiredFields() {
        return Sets.newHashSet((Object[])new String[]{EvaluationFields.ACTUAL_FIELD.getPreferredName(), EvaluationFields.PREDICTED_PROBABILITY_FIELD.getPreferredName()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AucRoc that = (AucRoc)o;
        return this.includeCurve == that.includeCurve;
    }

    public int hashCode() {
        return Objects.hash(this.includeCurve);
    }

    @Override
    public Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> aggs(EvaluationParameters parameters, EvaluationFields evaluationFields) {
        if (this.result.get() != null) {
            return Tuple.tuple(List.of(), List.of());
        }
        this.fields.trySet((Object)evaluationFields);
        String actualField = evaluationFields.getActualField();
        String predictedProbabilityField = evaluationFields.getPredictedProbabilityField();
        double[] percentiles = IntStream.range(1, 100).mapToDouble(v -> v).toArray();
        PercentilesAggregationBuilder percentilesAgg = ((PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)PERCENTILES_AGG_NAME).field(predictedProbabilityField)).percentiles(percentiles);
        AbstractAggregationBuilder percentilesForClassValueAgg = AggregationBuilders.filter((String)TRUE_AGG_NAME, (QueryBuilder)OutlierDetection.actualIsTrueQuery(actualField)).subAggregation((AggregationBuilder)percentilesAgg);
        AbstractAggregationBuilder percentilesForRestAgg = AggregationBuilders.filter((String)NON_TRUE_AGG_NAME, (QueryBuilder)QueryBuilders.boolQuery().mustNot(OutlierDetection.actualIsTrueQuery(actualField))).subAggregation((AggregationBuilder)percentilesAgg);
        return Tuple.tuple(List.of(percentilesForClassValueAgg, percentilesForRestAgg), List.of());
    }

    @Override
    public void process(Aggregations aggs) {
        if (this.result.get() != null) {
            return;
        }
        Filter classAgg = (Filter)aggs.get(TRUE_AGG_NAME);
        if (classAgg.getDocCount() == 0L) {
            throw ExceptionsHelper.badRequestException("[{}] requires at least one [{}] to have the value [{}]", this.getName(), ((EvaluationFields)this.fields.get()).getActualField(), "true");
        }
        double[] tpPercentiles = AucRoc.percentilesArray((Percentiles)classAgg.getAggregations().get(PERCENTILES_AGG_NAME));
        Filter restAgg = (Filter)aggs.get(NON_TRUE_AGG_NAME);
        if (restAgg.getDocCount() == 0L) {
            throw ExceptionsHelper.badRequestException("[{}] requires at least one [{}] to have a different value than [{}]", this.getName(), ((EvaluationFields)this.fields.get()).getActualField(), "true");
        }
        double[] fpPercentiles = AucRoc.percentilesArray((Percentiles)restAgg.getAggregations().get(PERCENTILES_AGG_NAME));
        List<AbstractAucRoc.AucRocPoint> aucRocCurve = AucRoc.buildAucRocCurve(tpPercentiles, fpPercentiles);
        double aucRocScore = AucRoc.calculateAucScore(aucRocCurve);
        this.result.set((Object)new AbstractAucRoc.Result(aucRocScore, this.includeCurve ? aucRocCurve : Collections.emptyList()));
    }

    public Optional<EvaluationMetricResult> getResult() {
        return Optional.ofNullable((EvaluationMetricResult)this.result.get());
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), INCLUDE_CURVE);
        TRUE_AGG_NAME = NAME.getPreferredName() + "_true";
        NON_TRUE_AGG_NAME = NAME.getPreferredName() + "_non_true";
    }
}

