/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.EmptyConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class InferTrainedModelDeploymentAction
extends ActionType<Response> {
    public static final InferTrainedModelDeploymentAction INSTANCE = new InferTrainedModelDeploymentAction();
    public static final String NAME = "cluster:monitor/xpack/ml/trained_models/deployment/infer";

    public InferTrainedModelDeploymentAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final List<InferenceResults> results;

        public Response(List<InferenceResults> results) {
            super(Collections.emptyList(), Collections.emptyList());
            this.results = Objects.requireNonNull(results);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.results = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_6_1) ? in.readNamedWriteableList(InferenceResults.class) : List.of((InferenceResults)in.readNamedWriteable(InferenceResults.class));
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_6_1)) {
                out.writeNamedWriteableList(this.results);
            } else {
                out.writeNamedWriteable((NamedWriteable)this.results.get(0));
            }
        }

        public List<InferenceResults> getResults() {
            return this.results;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.results.get(0).toXContent(builder, params);
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        public static final ParseField DOCS = new ParseField("docs", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField INFERENCE_CONFIG = new ParseField("inference_config", new String[0]);
        public static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)10L);
        static final ObjectParser<Builder, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/trained_models/deployment/infer", Builder::new);
        private String id;
        private final List<Map<String, Object>> docs;
        private final InferenceConfigUpdate update;
        private final TimeValue inferenceTimeout;
        private boolean highPriority = false;
        private final List<String> textInput;

        public static Builder parseRequest(String id, XContentParser parser) {
            Builder builder = (Builder)PARSER.apply(parser, null);
            if (id != null) {
                builder.setId(id);
            }
            return builder;
        }

        public static Request forDocs(String id, InferenceConfigUpdate update, List<Map<String, Object>> docs, TimeValue inferenceTimeout) {
            return new Request(ExceptionsHelper.requireNonNull(id, InferModelAction.Request.DEPLOYMENT_ID), update, ExceptionsHelper.requireNonNull(Collections.unmodifiableList(docs), DOCS), null, false, inferenceTimeout);
        }

        public static Request forTextInput(String id, InferenceConfigUpdate update, List<String> textInput, TimeValue inferenceTimeout) {
            return new Request(ExceptionsHelper.requireNonNull(id, InferModelAction.Request.DEPLOYMENT_ID), update, List.of(), ExceptionsHelper.requireNonNull(textInput, "inference text input"), false, inferenceTimeout);
        }

        Request(String id, InferenceConfigUpdate update, List<Map<String, Object>> docs, List<String> textInput, boolean highPriority, TimeValue inferenceTimeout) {
            this.id = ExceptionsHelper.requireNonNull(id, InferModelAction.Request.DEPLOYMENT_ID);
            this.docs = docs;
            this.textInput = textInput;
            this.update = update;
            this.inferenceTimeout = inferenceTimeout;
            this.highPriority = highPriority;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.docs = in.readImmutableList(StreamInput::readMap);
            this.update = (InferenceConfigUpdate)in.readOptionalNamedWriteable(InferenceConfigUpdate.class);
            this.inferenceTimeout = in.readOptionalTimeValue();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_3_0)) {
                this.highPriority = in.readBoolean();
            }
            this.textInput = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_7_0) ? in.readOptionalStringList() : null;
        }

        public String getId() {
            return this.id;
        }

        public List<Map<String, Object>> getDocs() {
            return this.docs;
        }

        public List<String> getTextInput() {
            return this.textInput;
        }

        public InferenceConfigUpdate getUpdate() {
            return Optional.ofNullable(this.update).orElse(new EmptyConfigUpdate());
        }

        public TimeValue getInferenceTimeout() {
            return this.inferenceTimeout == null ? DEFAULT_TIMEOUT : this.inferenceTimeout;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Nullable
        public TimeValue getTimeout() {
            return null;
        }

        public void setHighPriority(boolean highPriority) {
            this.highPriority = highPriority;
        }

        public boolean isHighPriority() {
            return this.highPriority;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = super.validate();
            if (this.docs == null) {
                validationException = ValidateActions.addValidationError((String)("[" + DOCS.getPreferredName() + "] must not be null"), (ActionRequestValidationException)validationException);
            } else if (this.docs.isEmpty() && this.textInput == null) {
                validationException = ValidateActions.addValidationError((String)"at least one document is required ", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeCollection(this.docs, StreamOutput::writeGenericMap);
            out.writeOptionalNamedWriteable((NamedWriteable)this.update);
            out.writeOptionalTimeValue(this.inferenceTimeout);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_3_0)) {
                out.writeBoolean(this.highPriority);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_7_0)) {
                out.writeOptionalStringCollection(this.textInput);
            }
        }

        public boolean match(Task task) {
            return StartTrainedModelDeploymentAction.TaskMatcher.match(task, this.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.id, that.id) && Objects.equals(this.docs, that.docs) && Objects.equals(this.update, that.update) && Objects.equals(this.inferenceTimeout, that.inferenceTimeout) && Objects.equals(this.highPriority, that.highPriority) && Objects.equals(this.textInput, that.textInput);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.update, this.docs, this.inferenceTimeout, this.highPriority, this.textInput);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format((String)"infer_trained_model_deployment[%s]", (Object[])new Object[]{this.id}), parentTaskId, headers);
        }

        static {
            PARSER.declareString(Builder::setId, InferModelAction.Request.DEPLOYMENT_ID);
            PARSER.declareObjectArray(Builder::setDocs, (p, c) -> p.mapOrdered(), DOCS);
            PARSER.declareString(Builder::setInferenceTimeout, TIMEOUT);
            PARSER.declareNamedObject(Builder::setUpdate, (p, c, name) -> (InferenceConfigUpdate)p.namedObject(InferenceConfigUpdate.class, name, c), INFERENCE_CONFIG);
        }

        public static class Builder {
            private String id;
            private List<Map<String, Object>> docs;
            private TimeValue timeout;
            private InferenceConfigUpdate update;
            private boolean skipQueue = false;
            private List<String> textInput;

            private Builder() {
            }

            public Builder setId(String id) {
                this.id = ExceptionsHelper.requireNonNull(id, InferModelAction.Request.DEPLOYMENT_ID);
                return this;
            }

            public Builder setDocs(List<Map<String, Object>> docs) {
                this.docs = ExceptionsHelper.requireNonNull(docs, DOCS);
                return this;
            }

            public Builder setInferenceTimeout(TimeValue inferenceTimeout) {
                this.timeout = inferenceTimeout;
                return this;
            }

            public Builder setUpdate(InferenceConfigUpdate update) {
                this.update = update;
                return this;
            }

            private Builder setInferenceTimeout(String inferenceTimeout) {
                return this.setInferenceTimeout(TimeValue.parseTimeValue((String)inferenceTimeout, (String)TIMEOUT.getPreferredName()));
            }

            public Builder setTextInput(List<String> textInput) {
                this.textInput = textInput;
                return this;
            }

            public Builder setSkipQueue(boolean skipQueue) {
                this.skipQueue = skipQueue;
                return this;
            }

            public Request build() {
                return new Request(this.id, this.update, this.docs, this.textInput, this.skipQueue, this.timeout);
            }
        }
    }
}

