/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.EmptyConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class InferModelAction
extends ActionType<Response> {
    public static final String NAME = "cluster:internal/xpack/ml/inference/infer";
    public static final String EXTERNAL_NAME = "cluster:monitor/xpack/ml/inference/infer";
    public static final InferModelAction INSTANCE = new InferModelAction("cluster:internal/xpack/ml/inference/infer");
    public static final InferModelAction EXTERNAL_INSTANCE = new InferModelAction("cluster:monitor/xpack/ml/inference/infer");

    private InferModelAction(String name) {
        super(name, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<InferenceResults> inferenceResults;
        private final String id;
        private final boolean isLicensed;

        public Response(List<InferenceResults> inferenceResults, String id, boolean isLicensed) {
            this.inferenceResults = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(inferenceResults, "inferenceResults"));
            this.isLicensed = isLicensed;
            this.id = id;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.inferenceResults = Collections.unmodifiableList(in.readNamedWriteableList(InferenceResults.class));
            this.isLicensed = in.readBoolean();
            this.id = in.readOptionalString();
        }

        public List<InferenceResults> getInferenceResults() {
            return this.inferenceResults;
        }

        public boolean isLicensed() {
            return this.isLicensed;
        }

        public String getId() {
            return this.id;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeNamedWriteableList(this.inferenceResults);
            out.writeBoolean(this.isLicensed);
            out.writeOptionalString(this.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.isLicensed == that.isLicensed && Objects.equals(this.inferenceResults, that.inferenceResults) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.inferenceResults, this.isLicensed, this.id);
        }

        public static Builder builder() {
            return new Builder();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("inference_results");
            for (InferenceResults inference : this.inferenceResults) {
                builder.startObject();
                inference.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public static class Builder {
            private List<InferenceResults> inferenceResults = new ArrayList<InferenceResults>();
            private String id;
            private boolean isLicensed;

            public Builder addInferenceResults(List<InferenceResults> inferenceResults) {
                this.inferenceResults.addAll(inferenceResults);
                return this;
            }

            public Builder setLicensed(boolean licensed) {
                this.isLicensed = licensed;
                return this;
            }

            public Builder setId(String id) {
                this.id = id;
                return this;
            }

            public Response build() {
                return new Response(this.inferenceResults, this.id, this.isLicensed);
            }
        }
    }

    public static class Request
    extends ActionRequest {
        public static final ParseField ID = new ParseField("id", new String[0]);
        public static final ParseField DEPLOYMENT_ID = new ParseField("deployment_id", new String[0]);
        public static final ParseField DOCS = new ParseField("docs", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField INFERENCE_CONFIG = new ParseField("inference_config", new String[0]);
        static final ObjectParser<Builder, Void> PARSER = new ObjectParser("cluster:internal/xpack/ml/inference/infer", Builder::new);
        public static final TimeValue DEFAULT_TIMEOUT_FOR_API;
        public static final TimeValue DEFAULT_TIMEOUT_FOR_INGEST;
        private final String id;
        private final List<Map<String, Object>> objectsToInfer;
        private final InferenceConfigUpdate update;
        private final boolean previouslyLicensed;
        private TimeValue inferenceTimeout;
        private final List<String> textInput;
        private boolean highPriority;

        public static Builder parseRequest(String id, XContentParser parser) {
            Builder builder = (Builder)PARSER.apply(parser, null);
            if (id != null) {
                builder.setId(id);
            }
            return builder;
        }

        public static Request forIngestDocs(String id, List<Map<String, Object>> docs, InferenceConfigUpdate update, boolean previouslyLicensed) {
            return new Request(ExceptionsHelper.requireNonNull(id, ID), update, ExceptionsHelper.requireNonNull(Collections.unmodifiableList(docs), DOCS), null, DEFAULT_TIMEOUT_FOR_INGEST, previouslyLicensed);
        }

        public static Request forTextInput(String id, InferenceConfigUpdate update, List<String> textInput) {
            return new Request(id, update, List.of(), ExceptionsHelper.requireNonNull(textInput, "inference text input"), DEFAULT_TIMEOUT_FOR_API, false);
        }

        Request(String id, InferenceConfigUpdate inferenceConfigUpdate, List<Map<String, Object>> docs, List<String> textInput, TimeValue inferenceTimeout, boolean previouslyLicensed) {
            this.id = ExceptionsHelper.requireNonNull(id, ID);
            this.objectsToInfer = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(docs, DOCS.getPreferredName()));
            this.update = ExceptionsHelper.requireNonNull(inferenceConfigUpdate, "inference_config");
            this.textInput = textInput;
            this.previouslyLicensed = previouslyLicensed;
            this.inferenceTimeout = inferenceTimeout;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.objectsToInfer = in.readImmutableList(StreamInput::readMap);
            this.update = (InferenceConfigUpdate)in.readNamedWriteable(InferenceConfigUpdate.class);
            this.previouslyLicensed = in.readBoolean();
            this.inferenceTimeout = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_3_0) ? in.readTimeValue() : TimeValue.MAX_VALUE;
            this.textInput = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_7_0) ? in.readOptionalStringList() : null;
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0)) {
                this.highPriority = in.readBoolean();
            }
        }

        public int numberOfDocuments() {
            if (this.textInput != null) {
                return this.textInput.size();
            }
            return this.objectsToInfer.size();
        }

        public String getId() {
            return this.id;
        }

        public List<Map<String, Object>> getObjectsToInfer() {
            return this.objectsToInfer;
        }

        public List<String> getTextInput() {
            return this.textInput;
        }

        public InferenceConfigUpdate getUpdate() {
            return this.update;
        }

        public boolean isPreviouslyLicensed() {
            return this.previouslyLicensed;
        }

        public TimeValue getInferenceTimeout() {
            return this.inferenceTimeout;
        }

        public Request setInferenceTimeout(TimeValue inferenceTimeout) {
            this.inferenceTimeout = inferenceTimeout;
            return this;
        }

        public boolean isHighPriority() {
            return this.highPriority;
        }

        public void setHighPriority(boolean highPriority) {
            this.highPriority = highPriority;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeCollection(this.objectsToInfer, StreamOutput::writeGenericMap);
            out.writeNamedWriteable((NamedWriteable)this.update);
            out.writeBoolean(this.previouslyLicensed);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_3_0)) {
                out.writeTimeValue(this.inferenceTimeout);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_7_0)) {
                out.writeOptionalStringCollection(this.textInput);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0)) {
                out.writeBoolean(this.highPriority);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.id, that.id) && Objects.equals(this.update, that.update) && Objects.equals(this.previouslyLicensed, that.previouslyLicensed) && Objects.equals(this.inferenceTimeout, that.inferenceTimeout) && Objects.equals(this.objectsToInfer, that.objectsToInfer) && Objects.equals(this.textInput, that.textInput) && this.highPriority == that.highPriority;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format((String)"infer_trained_model[%s]", (Object[])new Object[]{this.id}), parentTaskId, headers);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.objectsToInfer, this.update, this.previouslyLicensed, this.inferenceTimeout, this.textInput, this.highPriority);
        }

        static {
            PARSER.declareString(Builder::setId, ID);
            PARSER.declareObjectArray(Builder::setDocs, (p, c) -> p.mapOrdered(), DOCS);
            PARSER.declareString(Builder::setInferenceTimeout, TIMEOUT);
            PARSER.declareNamedObject(Builder::setUpdate, (p, c, name) -> (InferenceConfigUpdate)p.namedObject(InferenceConfigUpdate.class, name, c), INFERENCE_CONFIG);
            DEFAULT_TIMEOUT_FOR_API = TimeValue.timeValueSeconds((long)10L);
            DEFAULT_TIMEOUT_FOR_INGEST = TimeValue.MAX_VALUE;
        }

        public static class Builder {
            private String id;
            private List<Map<String, Object>> docs;
            private TimeValue timeout;
            private InferenceConfigUpdate update = new EmptyConfigUpdate();

            private Builder() {
            }

            public Builder setId(String id) {
                this.id = ExceptionsHelper.requireNonNull(id, ID);
                return this;
            }

            public Builder setDocs(List<Map<String, Object>> docs) {
                this.docs = ExceptionsHelper.requireNonNull(docs, DOCS);
                return this;
            }

            public Builder setInferenceTimeout(TimeValue inferenceTimeout) {
                this.timeout = inferenceTimeout;
                return this;
            }

            public Builder setUpdate(InferenceConfigUpdate update) {
                this.update = update;
                return this;
            }

            public InferenceConfigUpdate getUpdate() {
                return this.update;
            }

            private Builder setInferenceTimeout(String inferenceTimeout) {
                return this.setInferenceTimeout(TimeValue.parseTimeValue((String)inferenceTimeout, (String)TIMEOUT.getPreferredName()));
            }

            public Request build() {
                return new Request(this.id, this.update, this.docs, null, this.timeout, false);
            }
        }
    }
}

