/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.downsample.DownsampleAfterBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleBeforeBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleBulkStats;
import org.elasticsearch.xpack.core.downsample.DownsampleShardIndexerStatus;
import org.elasticsearch.xpack.core.downsample.DownsampleShardStatus;

public class DownsampleShardTask
extends AllocatedPersistentTask {
    public static final String TASK_NAME = "rollup-shard";
    private final String downsampleIndex;
    private volatile long totalShardDocCount;
    private volatile long docsProcessed;
    private final long indexStartTimeMillis;
    private final long indexEndTimeMillis;
    private final DownsampleConfig config;
    private final ShardId shardId;
    private final long rollupStartTime;
    private final AtomicLong numReceived = new AtomicLong(0L);
    private final AtomicLong numSent = new AtomicLong(0L);
    private final AtomicLong numIndexed = new AtomicLong(0L);
    private final AtomicLong numFailed = new AtomicLong(0L);
    private final AtomicLong lastSourceTimestamp = new AtomicLong(0L);
    private final AtomicLong lastTargetTimestamp = new AtomicLong(0L);
    private final AtomicLong lastIndexingTimestamp = new AtomicLong(0L);
    private final AtomicReference<DownsampleShardIndexerStatus> downsampleShardIndexerStatus = new AtomicReference<DownsampleShardIndexerStatus>(DownsampleShardIndexerStatus.INITIALIZED);
    private final DownsampleBulkStats downsampleBulkStats;
    private final AtomicReference<DownsampleBeforeBulkInfo> lastBeforeBulkInfo = new AtomicReference<DownsampleBeforeBulkInfo>(new DownsampleBeforeBulkInfo(0L, 0L, 0L, 0));
    private final AtomicReference<DownsampleAfterBulkInfo> lastAfterBulkInfo = new AtomicReference<DownsampleAfterBulkInfo>(new DownsampleAfterBulkInfo(0L, 0L, 0L, 0L, false, 0));

    public DownsampleShardTask(long id, String type, String action, TaskId parentTask, String downsampleIndex, long indexStartTimeMillis, long indexEndTimeMillis, DownsampleConfig config, Map<String, String> headers, ShardId shardId) {
        super(id, type, action, "rollup_" + downsampleIndex + "[" + shardId.id() + "]", parentTask, headers);
        this.downsampleIndex = downsampleIndex;
        this.indexStartTimeMillis = indexStartTimeMillis;
        this.indexEndTimeMillis = indexEndTimeMillis;
        this.config = config;
        this.shardId = shardId;
        this.rollupStartTime = System.currentTimeMillis();
        this.downsampleBulkStats = new DownsampleBulkStats();
    }

    protected void init(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        super.init(persistentTasksService, taskManager, persistentTaskId, allocationId);
    }

    public void testInit(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        this.init(persistentTasksService, taskManager, persistentTaskId, allocationId);
    }

    public String getDownsampleIndex() {
        return this.downsampleIndex;
    }

    public DownsampleConfig config() {
        return this.config;
    }

    public long getTotalShardDocCount() {
        return this.totalShardDocCount;
    }

    public Task.Status getStatus() {
        return new DownsampleShardStatus(this.shardId, this.rollupStartTime, this.numReceived.get(), this.numSent.get(), this.numIndexed.get(), this.numFailed.get(), this.totalShardDocCount, this.lastSourceTimestamp.get(), this.lastTargetTimestamp.get(), this.lastIndexingTimestamp.get(), this.indexStartTimeMillis, this.indexEndTimeMillis, this.docsProcessed, 100.0f * (float)this.docsProcessed / (float)this.totalShardDocCount, this.downsampleBulkStats.getRollupBulkInfo(), this.lastBeforeBulkInfo.get(), this.lastAfterBulkInfo.get(), this.downsampleShardIndexerStatus.get());
    }

    public long getNumReceived() {
        return this.numReceived.get();
    }

    public long getNumSent() {
        return this.numSent.get();
    }

    public long getNumIndexed() {
        return this.numIndexed.get();
    }

    public long getNumFailed() {
        return this.numFailed.get();
    }

    public long getLastSourceTimestamp() {
        return this.lastSourceTimestamp.get();
    }

    public long getLastTargetTimestamp() {
        return this.lastTargetTimestamp.get();
    }

    public DownsampleBeforeBulkInfo getLastBeforeBulkInfo() {
        return this.lastBeforeBulkInfo.get();
    }

    public DownsampleAfterBulkInfo getLastAfterBulkInfo() {
        return this.lastAfterBulkInfo.get();
    }

    public long getDocsProcessed() {
        return this.docsProcessed;
    }

    public long getRollupStartTime() {
        return this.rollupStartTime;
    }

    public DownsampleShardIndexerStatus getDownsampleShardIndexerStatus() {
        return this.downsampleShardIndexerStatus.get();
    }

    public long getLastIndexingTimestamp() {
        return this.lastIndexingTimestamp.get();
    }

    public long getIndexStartTimeMillis() {
        return this.indexStartTimeMillis;
    }

    public long getIndexEndTimeMillis() {
        return this.indexEndTimeMillis;
    }

    public float getDocsProcessedPercentage() {
        return this.getTotalShardDocCount() <= 0L ? 0.0f : 100.0f * (float)this.docsProcessed / (float)this.totalShardDocCount;
    }

    public void addNumReceived(long count) {
        this.numReceived.addAndGet(count);
    }

    public void addNumSent(long count) {
        this.numSent.addAndGet(count);
    }

    public void addNumIndexed(long count) {
        this.numIndexed.addAndGet(count);
    }

    public void addNumFailed(long count) {
        this.numFailed.addAndGet(count);
    }

    public void setLastSourceTimestamp(long timestamp) {
        this.lastSourceTimestamp.set(timestamp);
    }

    public void setLastTargetTimestamp(long timestamp) {
        this.lastTargetTimestamp.set(timestamp);
    }

    public void setLastIndexingTimestamp(long timestamp) {
        this.lastIndexingTimestamp.set(timestamp);
    }

    public void setBeforeBulkInfo(DownsampleBeforeBulkInfo beforeBulkInfo) {
        this.lastBeforeBulkInfo.set(beforeBulkInfo);
    }

    public void setAfterBulkInfo(DownsampleAfterBulkInfo afterBulkInfo) {
        this.lastAfterBulkInfo.set(afterBulkInfo);
    }

    public void setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus status) {
        this.downsampleShardIndexerStatus.set(status);
    }

    public void setTotalShardDocCount(int totalShardDocCount) {
        this.totalShardDocCount = totalShardDocCount;
    }

    public void setDocsProcessed(long docsProcessed) {
        this.docsProcessed = docsProcessed;
    }

    public void updateBulkInfo(long bulkIngestTookMillis, long bulkTookMillis) {
        this.downsampleBulkStats.update(bulkIngestTookMillis, bulkTookMillis);
    }

    public DownsampleBulkInfo getDownsampleBulkInfo() {
        return this.downsampleBulkStats.getRollupBulkInfo();
    }
}

