/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.downsample.DownsampleAfterBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleBeforeBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleShardIndexerStatus;

public class DownsampleShardStatus
implements Task.Status {
    public static final String NAME = "rollup-index-shard";
    private static final ParseField SHARD_FIELD = new ParseField("shard", new String[0]);
    private static final ParseField START_TIME_FIELD = new ParseField("start_time", new String[0]);
    private static final ParseField IN_NUM_DOCS_RECEIVED_FIELD = new ParseField("in_num_docs_received", new String[0]);
    private static final ParseField OUT_NUM_DOCS_SENT_FIELD = new ParseField("out_num_docs_sent", new String[0]);
    private static final ParseField OUT_NUM_DOCS_INDEXED_FIELD = new ParseField("out_num_docs_indexed", new String[0]);
    private static final ParseField OUT_NUM_DOCS_FAILED_FIELD = new ParseField("out_num_docs_failed", new String[0]);
    private static final ParseField TOTAL_SHARD_DOC_COUNT = new ParseField("total_shard_doc_count", new String[0]);
    private static final ParseField LAST_SOURCE_TIMESTAMP = new ParseField("last_source_timestamp", new String[0]);
    private static final ParseField LAST_TARGET_TIMESTAMP = new ParseField("last_target_timestamp", new String[0]);
    private static final ParseField LAST_INDEXING_TIMESTAMP = new ParseField("last_indexing_timestamp", new String[0]);
    private static final ParseField DOCS_PROCESSED = new ParseField("docs_processed", new String[0]);
    private static final ParseField INDEX_START_TIME_MILLIS = new ParseField("index_start_time", new String[0]);
    private static final ParseField INDEX_END_TIME_MILLIS = new ParseField("index_end_time", new String[0]);
    private static final ParseField DOCS_PROCESSED_PERCENTAGE = new ParseField("docs_processed_percentage", new String[0]);
    private static final ParseField ROLLUP_BULK_INFO = new ParseField("rollup_bulk_info", new String[0]);
    private static final ParseField ROLLUP_BEFORE_BULK_INFO = new ParseField("rollup_before_bulk_info", new String[0]);
    private static final ParseField ROLLUP_AFTER_BULK_INFO = new ParseField("rollup_after_bulk_info", new String[0]);
    private static final ParseField ROLLUP_SHARD_INDEXER_STATUS = new ParseField("rollup_shard_indexer_status", new String[0]);
    private final ShardId shardId;
    private final long rollupStart;
    private final long numReceived;
    private final long numSent;
    private final long numIndexed;
    private final long numFailed;
    private final long totalShardDocCount;
    private final long lastSourceTimestamp;
    private final long lastTargetTimestamp;
    private final long lastIndexingTimestamp;
    private final long indexStartTimeMillis;
    private final long indexEndTimeMillis;
    private final long docsProcessed;
    private final float docsProcessedPercentage;
    private final DownsampleBulkInfo downsampleBulkInfo;
    private final DownsampleBeforeBulkInfo downsampleBeforeBulkInfo;
    private final DownsampleAfterBulkInfo downsampleAfterBulkInfo;
    private final DownsampleShardIndexerStatus downsampleShardIndexerStatus;
    private static final ConstructingObjectParser<DownsampleShardStatus, Void> PARSER = new ConstructingObjectParser("rollup-index-shard", args -> {
        ShardId _shardId = ShardId.fromString((String)((String)args[0]));
        long _rollupStart = Instant.parse((String)args[1]).toEpochMilli();
        Long _numReceived = (Long)args[2];
        Long _numSent = (Long)args[3];
        Long _numIndexed = (Long)args[4];
        Long _numFailed = (Long)args[5];
        Long _totalShardDocCount = (Long)args[6];
        Long _lastSourceTimestamp = (Long)args[7];
        Long _lastTargetTimestamp = (Long)args[8];
        Long _lastIndexingTimestamp = (Long)args[9];
        Long _indexStartTimeMillis = (Long)args[10];
        Long _indexEndTimeMillis = (Long)args[11];
        Long _docsProcessed = (Long)args[12];
        Float _docsProcessedPercentage = (Float)args[13];
        DownsampleBulkInfo _downsampleBulkInfo = (DownsampleBulkInfo)args[14];
        DownsampleBeforeBulkInfo _downsampleBeforeBulkInfo = (DownsampleBeforeBulkInfo)args[15];
        DownsampleAfterBulkInfo _downsampleAfterBulkInfo = (DownsampleAfterBulkInfo)args[16];
        DownsampleShardIndexerStatus _downsampleShardIndexerStatus = DownsampleShardIndexerStatus.valueOf((String)args[17]);
        return new DownsampleShardStatus(_shardId, _rollupStart, _numReceived, _numSent, _numIndexed, _numFailed, _totalShardDocCount, _lastSourceTimestamp, _lastTargetTimestamp, _lastIndexingTimestamp, _indexStartTimeMillis, _indexEndTimeMillis, _docsProcessed, _docsProcessedPercentage.floatValue(), _downsampleBulkInfo, _downsampleBeforeBulkInfo, _downsampleAfterBulkInfo, _downsampleShardIndexerStatus);
    });

    public DownsampleShardStatus(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.rollupStart = in.readLong();
        this.numReceived = in.readLong();
        this.numSent = in.readLong();
        this.numIndexed = in.readLong();
        this.numFailed = in.readLong();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_500_030) && in.readBoolean()) {
            this.totalShardDocCount = in.readVLong();
            this.lastSourceTimestamp = in.readVLong();
            this.lastTargetTimestamp = in.readVLong();
            this.lastIndexingTimestamp = in.readVLong();
            this.indexStartTimeMillis = in.readVLong();
            this.indexEndTimeMillis = in.readVLong();
            this.docsProcessed = in.readVLong();
            this.docsProcessedPercentage = in.readFloat();
            this.downsampleBulkInfo = new DownsampleBulkInfo(in);
            this.downsampleBeforeBulkInfo = new DownsampleBeforeBulkInfo(in);
            this.downsampleAfterBulkInfo = new DownsampleAfterBulkInfo(in);
            this.downsampleShardIndexerStatus = (DownsampleShardIndexerStatus)in.readEnum(DownsampleShardIndexerStatus.class);
        } else {
            this.totalShardDocCount = -1L;
            this.lastSourceTimestamp = -1L;
            this.lastTargetTimestamp = -1L;
            this.lastIndexingTimestamp = -1L;
            this.indexStartTimeMillis = -1L;
            this.indexEndTimeMillis = -1L;
            this.docsProcessed = 0L;
            this.docsProcessedPercentage = 0.0f;
            this.downsampleBulkInfo = null;
            this.downsampleBeforeBulkInfo = null;
            this.downsampleAfterBulkInfo = null;
            this.downsampleShardIndexerStatus = null;
        }
    }

    public DownsampleShardStatus(ShardId shardId, long rollupStart, long numReceived, long numSent, long numIndexed, long numFailed, long totalShardDocCount, long lastSourceTimestamp, long lastTargetTimestamp, long lastIndexingTimestamp, long indexStartTimeMillis, long indexEndTimeMillis, long docsProcessed, float docsProcessedPercentage, DownsampleBulkInfo downsampleBulkInfo, DownsampleBeforeBulkInfo downsampleBeforeBulkInfo, DownsampleAfterBulkInfo downsampleAfterBulkInfo, DownsampleShardIndexerStatus downsampleShardIndexerStatus) {
        this.shardId = shardId;
        this.rollupStart = rollupStart;
        this.numReceived = numReceived;
        this.numSent = numSent;
        this.numIndexed = numIndexed;
        this.numFailed = numFailed;
        this.totalShardDocCount = totalShardDocCount;
        this.lastSourceTimestamp = lastSourceTimestamp;
        this.lastTargetTimestamp = lastTargetTimestamp;
        this.lastIndexingTimestamp = lastIndexingTimestamp;
        this.indexStartTimeMillis = indexStartTimeMillis;
        this.indexEndTimeMillis = indexEndTimeMillis;
        this.docsProcessed = docsProcessed;
        this.docsProcessedPercentage = docsProcessedPercentage;
        this.downsampleBulkInfo = downsampleBulkInfo;
        this.downsampleBeforeBulkInfo = downsampleBeforeBulkInfo;
        this.downsampleAfterBulkInfo = downsampleAfterBulkInfo;
        this.downsampleShardIndexerStatus = downsampleShardIndexerStatus;
    }

    public static DownsampleShardStatus fromXContent(XContentParser parser) throws IOException {
        return (DownsampleShardStatus)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SHARD_FIELD.getPreferredName(), (ToXContent)this.shardId);
        builder.field(START_TIME_FIELD.getPreferredName(), Instant.ofEpochMilli(this.rollupStart).toString());
        builder.field(IN_NUM_DOCS_RECEIVED_FIELD.getPreferredName(), this.numReceived);
        builder.field(OUT_NUM_DOCS_SENT_FIELD.getPreferredName(), this.numSent);
        builder.field(OUT_NUM_DOCS_INDEXED_FIELD.getPreferredName(), this.numIndexed);
        builder.field(OUT_NUM_DOCS_FAILED_FIELD.getPreferredName(), this.numFailed);
        builder.field(TOTAL_SHARD_DOC_COUNT.getPreferredName(), this.totalShardDocCount);
        builder.field(LAST_SOURCE_TIMESTAMP.getPreferredName(), this.lastSourceTimestamp);
        builder.field(LAST_TARGET_TIMESTAMP.getPreferredName(), this.lastTargetTimestamp);
        builder.field(LAST_INDEXING_TIMESTAMP.getPreferredName(), this.lastIndexingTimestamp);
        builder.field(INDEX_START_TIME_MILLIS.getPreferredName(), this.indexStartTimeMillis);
        builder.field(INDEX_END_TIME_MILLIS.getPreferredName(), this.indexEndTimeMillis);
        builder.field(DOCS_PROCESSED.getPreferredName(), this.docsProcessed);
        builder.field(DOCS_PROCESSED_PERCENTAGE.getPreferredName(), this.docsProcessedPercentage);
        this.downsampleBulkInfo.toXContent(builder, params);
        this.downsampleBeforeBulkInfo.toXContent(builder, params);
        this.downsampleAfterBulkInfo.toXContent(builder, params);
        builder.field(ROLLUP_SHARD_INDEXER_STATUS.getPreferredName(), (Enum)this.downsampleShardIndexerStatus);
        return builder.endObject();
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeLong(this.rollupStart);
        out.writeLong(this.numReceived);
        out.writeLong(this.numSent);
        out.writeLong(this.numIndexed);
        out.writeLong(this.numFailed);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_500_030)) {
            out.writeBoolean(true);
            out.writeVLong(this.totalShardDocCount);
            out.writeVLong(this.lastSourceTimestamp);
            out.writeVLong(this.lastTargetTimestamp);
            out.writeVLong(this.lastIndexingTimestamp);
            out.writeVLong(this.indexStartTimeMillis);
            out.writeVLong(this.indexEndTimeMillis);
            out.writeVLong(this.docsProcessed);
            out.writeFloat(this.docsProcessedPercentage);
            this.downsampleBulkInfo.writeTo(out);
            this.downsampleBeforeBulkInfo.writeTo(out);
            this.downsampleAfterBulkInfo.writeTo(out);
            out.writeEnum((Enum)this.downsampleShardIndexerStatus);
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownsampleShardStatus that = (DownsampleShardStatus)o;
        return this.rollupStart == that.rollupStart && this.numReceived == that.numReceived && this.numSent == that.numSent && this.numIndexed == that.numIndexed && this.numFailed == that.numFailed && this.totalShardDocCount == that.totalShardDocCount && this.lastSourceTimestamp == that.lastSourceTimestamp && this.lastTargetTimestamp == that.lastTargetTimestamp && this.lastIndexingTimestamp == that.lastIndexingTimestamp && this.indexStartTimeMillis == that.indexStartTimeMillis && this.indexEndTimeMillis == that.indexEndTimeMillis && this.docsProcessed == that.docsProcessed && this.docsProcessedPercentage == that.docsProcessedPercentage && Objects.equals(this.shardId.getIndexName(), that.shardId.getIndexName()) && Objects.equals(this.shardId.id(), that.shardId.id()) && Objects.equals(this.downsampleBulkInfo, that.downsampleBulkInfo) && Objects.equals(this.downsampleBeforeBulkInfo, that.downsampleBeforeBulkInfo) && Objects.equals(this.downsampleAfterBulkInfo, that.downsampleAfterBulkInfo) && Objects.equals((Object)this.downsampleShardIndexerStatus, (Object)that.downsampleShardIndexerStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shardId.getIndexName(), this.shardId.id(), this.rollupStart, this.numReceived, this.numSent, this.numIndexed, this.numFailed, this.totalShardDocCount, this.lastSourceTimestamp, this.lastTargetTimestamp, this.lastIndexingTimestamp, this.indexStartTimeMillis, this.indexEndTimeMillis, this.docsProcessed, Float.valueOf(this.docsProcessedPercentage), this.downsampleBulkInfo, this.downsampleBeforeBulkInfo, this.downsampleAfterBulkInfo, this.downsampleShardIndexerStatus});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SHARD_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), START_TIME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), IN_NUM_DOCS_RECEIVED_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), OUT_NUM_DOCS_SENT_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), OUT_NUM_DOCS_INDEXED_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), OUT_NUM_DOCS_FAILED_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_SHARD_DOC_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_SOURCE_TIMESTAMP);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_TARGET_TIMESTAMP);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_INDEXING_TIMESTAMP);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_START_TIME_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_END_TIME_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), DOCS_PROCESSED);
        PARSER.declareFloat(ConstructingObjectParser.constructorArg(), DOCS_PROCESSED_PERCENTAGE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DownsampleBulkInfo.fromXContext(p), ROLLUP_BULK_INFO);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DownsampleBeforeBulkInfo.fromXContent(p), ROLLUP_BEFORE_BULK_INFO);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DownsampleAfterBulkInfo.fromXContent(p), ROLLUP_AFTER_BULK_INFO);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ROLLUP_SHARD_INDEXER_STATUS);
    }
}

