/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datastreams;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class DataStreamFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final DataStreamStats streamStats;

    public DataStreamFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.streamStats = new DataStreamStats(input);
    }

    public DataStreamFeatureSetUsage(DataStreamStats stats) {
        super("data_streams", true, true);
        this.streamStats = stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.streamStats.writeTo(out);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.V_7_9_0;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("data_streams", this.streamStats.totalDataStreamCount);
        builder.field("indices_count", this.streamStats.indicesBehindDataStream);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return this.streamStats.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataStreamFeatureSetUsage other = (DataStreamFeatureSetUsage)obj;
        return Objects.equals(this.streamStats, other.streamStats);
    }

    public static class DataStreamStats
    implements Writeable {
        private final long totalDataStreamCount;
        private final long indicesBehindDataStream;

        public DataStreamStats(long totalDataStreamCount, long indicesBehindDataStream) {
            this.totalDataStreamCount = totalDataStreamCount;
            this.indicesBehindDataStream = indicesBehindDataStream;
        }

        public DataStreamStats(StreamInput in) throws IOException {
            this.totalDataStreamCount = in.readVLong();
            this.indicesBehindDataStream = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.totalDataStreamCount);
            out.writeVLong(this.indicesBehindDataStream);
        }

        public int hashCode() {
            return Objects.hash(this.totalDataStreamCount, this.indicesBehindDataStream);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DataStreamStats other = (DataStreamStats)obj;
            return this.totalDataStreamCount == other.totalDataStreamCount && this.indicesBehindDataStream == other.indicesBehindDataStream;
        }
    }
}

