/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class AsyncTaskMaintenanceService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    public static final Setting<TimeValue> ASYNC_SEARCH_CLEANUP_INTERVAL_SETTING = Setting.timeSetting((String)"async_search.index_cleanup_interval", (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(AsyncTaskMaintenanceService.class);
    private final ClusterService clusterService;
    private final String index;
    private final String localNodeId;
    private final ThreadPool threadPool;
    private final Client clientWithOrigin;
    private final TimeValue delay;
    private final AtomicBoolean isPaused = new AtomicBoolean(false);
    private boolean isCleanupRunning;
    private volatile Scheduler.Cancellable cancellable;

    public AsyncTaskMaintenanceService(ClusterService clusterService, String localNodeId, Settings nodeSettings, ThreadPool threadPool, Client clientWithOrigin) {
        this.clusterService = clusterService;
        this.index = ".async-search";
        this.localNodeId = localNodeId;
        this.threadPool = threadPool;
        this.clientWithOrigin = clientWithOrigin;
        this.delay = (TimeValue)ASYNC_SEARCH_CLEANUP_INTERVAL_SETTING.get(nodeSettings);
    }

    protected void doStart() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    protected void doStop() {
        this.clusterService.removeListener((ClusterStateListener)this);
        this.stopCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (this.isPaused.compareAndSet(false, true)) {
            Lifecycle lifecycle = this.lifecycle;
            synchronized (lifecycle) {
                assert (this.lifecycle.started());
                this.doStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unpause() {
        if (this.isPaused.compareAndSet(true, false)) {
            Lifecycle lifecycle = this.lifecycle;
            synchronized (lifecycle) {
                assert (this.lifecycle.started());
                this.doStart();
            }
            return true;
        }
        return false;
    }

    protected final void doClose() throws IOException {
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.tryStartCleanup(state);
    }

    synchronized void tryStartCleanup(ClusterState state) {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        IndexRoutingTable indexRouting = state.routingTable().index(this.index);
        if (indexRouting == null) {
            this.stopCleanup();
            return;
        }
        String primaryNodeId = indexRouting.shard(0).primaryShard().currentNodeId();
        if (this.localNodeId.equals(primaryNodeId)) {
            if (!this.isCleanupRunning) {
                this.isCleanupRunning = true;
                this.executeNextCleanup();
            }
        } else {
            this.stopCleanup();
        }
    }

    synchronized void executeNextCleanup() {
        if (this.isCleanupRunning) {
            long nowInMillis = System.currentTimeMillis();
            DeleteByQueryRequest toDelete = new DeleteByQueryRequest(new String[]{this.index}).setQuery((QueryBuilder)QueryBuilders.rangeQuery((String)"expiration_time").lte((Object)nowInMillis));
            this.clientWithOrigin.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)toDelete, ActionListener.running(this::scheduleNextCleanup));
        }
    }

    synchronized void scheduleNextCleanup() {
        if (this.isCleanupRunning) {
            try {
                this.cancellable = this.threadPool.schedule(this::executeNextCleanup, this.delay, "generic");
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.debug("failed to schedule next maintenance task; shutting down", (Throwable)e);
                }
                throw e;
            }
        }
    }

    synchronized void stopCleanup() {
        if (this.isCleanupRunning) {
            if (this.cancellable != null && !this.cancellable.isCancelled()) {
                this.cancellable.cancel();
            }
            this.isCleanupRunning = false;
        }
    }
}

